/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.af.integration;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.osgi.framework.Version;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.platform.sirius.ted.IMetadataProvider;
import org.polarsys.capella.core.af.integration.AFIntegrationPlugin;
import org.polarsys.capella.core.af.integration.Messages;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class CapellaMetadataProvider
implements IMetadataProvider {
    public static Version getCurrentVersion() {
        try {
            Version version = ViewpointManager.readVersion((Resource)ViewpointManager.getViewpoint((String)"org.polarsys.capella.core.viewpoint"));
            return version;
        }
        catch (Exception e) {
            return Version.parseVersion((String)FeatureHelper.getCapellaVersion((boolean)false));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Version> getViewpointsUsage(IFile afmFile) {
        resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put("ABORT_ON_ERROR", Boolean.TRUE);
        resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        try {
            resourceSet.getResource(EcoreUtil2.getURI((IFile)afmFile), true);
            var3_2 = MetadataHelper.getViewpointMetadata((ResourceSet)resourceSet).getViewpointReferences();
            return var3_2;
        }
        finally {
            ** for (r : resourceSet.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl15:
        // 1 sources

        resourceSet.getResources().clear();
        return var3_2;
    }

    public static IFile getAFM(IFile fileToMigrate) {
        IFile file = fileToMigrate.getProject().getFile(fileToMigrate.getProjectRelativePath().removeFileExtension().addFileExtension("afm"));
        return file;
    }

    public IStatus checkVersion(IFile file) {
        IFile afm = CapellaMetadataProvider.getAFM(file);
        if (!afm.exists()) {
            Version fileVersion = CapellaFeatureHelper.getFileVersion((IFile)file);
            Version currentVersion = CapellaMetadataProvider.getCurrentVersion();
            return this.isMigrationRequired(fileVersion, currentVersion);
        }
        return this.checkMetadata(file);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus checkMetadata(IFile file) {
        afm = CapellaMetadataProvider.getAFM(file);
        if (!afm.exists()) {
            return new Status(4, AFIntegrationPlugin.getSymbolicName(), NLS.bind((String)Messages.NoMetadataException_Message, (Object)EcoreUtil2.getURI((IFile)file).toPlatformString(true)));
        }
        set = new ResourceSetImpl();
        set.getLoadOptions().put("ABORT_ON_ERROR", Boolean.TRUE);
        set.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        try {
            uri = EcoreUtil2.getURI((IFile)file);
            set.getResource(uri, true);
            var6_6 = this.checkMetadata(uri, (ResourceSet)set);
            return var6_6;
        }
        catch (Exception e) {
            var6_7 = new Status(4, AFIntegrationPlugin.getSymbolicName(), e.getMessage());
            return var6_7;
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl22:
        // 1 sources

        set.getResources().clear();
        return var6_7;
    }

    public IStatus checkMetadata(URI sessionResourceURI, ResourceSet set) {
        if (!ViewpointManager.getInstance((ResourceSet)set).hasMetadata()) {
            if (CapellaResourceHelper.isCapellaProject((URI)sessionResourceURI)) {
                return new Status(4, AFIntegrationPlugin.getSymbolicName(), NLS.bind((String)Messages.NoMetadataException_Message, (Object)MetadataHelper.getViewpointMetadata((ResourceSet)set).getExpectedMetadataStorageURI().toPlatformString(true)));
            }
        } else {
            Version currentVersion;
            IStatus migration;
            Version fileVersion;
            Resource vp = ViewpointManager.getViewpoint((String)"org.polarsys.capella.core.viewpoint");
            if (vp != null && (fileVersion = MetadataHelper.getViewpointMetadata((ResourceSet)set).getVersion(vp)) != null && !(migration = this.isMigrationRequired(fileVersion, currentVersion = CapellaMetadataProvider.getCurrentVersion())).isOK()) {
                return migration;
            }
            IStatus result = ViewpointManager.checkViewpointsCompliancy((ResourceSet)set);
            if (!result.isOK()) {
                return result;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus isMigrationRequired(Version fileVersion, Version currentVersion) {
        if (fileVersion.getMajor() != currentVersion.getMajor() || fileVersion.getMinor() != currentVersion.getMinor()) {
            return new Status(4, AFIntegrationPlugin.getSymbolicName(), Messages.WrongCapellaVersionException_Message);
        }
        if ((fileVersion.getMajor() == 1 && fileVersion.getMinor() == 1 || fileVersion.getMajor() == 1 && fileVersion.getMinor() == 2 && fileVersion.getMicro() == 0) && currentVersion.getMajor() == 1 && currentVersion.getMinor() == 2 && currentVersion.getMicro() > 0) {
            return new Status(4, AFIntegrationPlugin.getSymbolicName(), NLS.bind((String)Messages.WrongCapellaVersionException_DetailedMessage, (Object)fileVersion));
        }
        return Status.OK_STATUS;
    }

    public void registerMetadataResource(org.eclipse.emf.ecore.resource.Resource resource, final Session session, final IProgressMonitor monitor) {
        if (resource != null && session != null) {
            final URI metadataResourceURI = resource.getURI();
            ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)session.getTransactionalEditingDomain()).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    session.addSemanticResource(metadataResourceURI, monitor);
                }
            });
        }
    }

    public org.eclipse.emf.ecore.resource.Resource createMetadataResource(TransactionalEditingDomain domain, URI resourceURI, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            if (!CapellaResourceHelper.isCapellaProject((URI)resourceURI)) {
                return null;
            }
            URI uri = resourceURI.trimFileExtension().appendFileExtension("afm");
            progress.beginTask("Create an empty metadata resource", 1);
            org.eclipse.emf.ecore.resource.Resource resource = MetadataHelper.getViewpointMetadata((ResourceSet)domain.getResourceSet()).initMetadataStorage(uri);
            progress.worked(1);
            try {
                progress.beginTask("Save metadata model", 1);
                resource.save(Collections.emptyMap());
            }
            catch (Exception exception) {
                // empty catch block
            }
            progress.worked(1);
            org.eclipse.emf.ecore.resource.Resource resource2 = resource;
            return resource2;
        }
        finally {
            progress.done();
        }
    }
}

