/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnOverrideLabelAccumulator
extends AbstractOverrider
implements IPersistable {
    public static final String PERSISTENCE_KEY = ".columnOverrideLabelAccumulator";
    private final ILayer layer;
    public static final String ALL_COLUMN_KEY = "ALL_COLUMNS";

    public ColumnOverrideLabelAccumulator(ILayer layer) {
        this.layer = layer;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        int columnIndex = this.layer.getColumnIndexByPosition(columnPosition);
        this.addOverrides(configLabels, Integer.valueOf(columnIndex));
        this.addOverrides(configLabels, (Serializable)((Object)ALL_COLUMN_KEY));
    }

    private void addOverrides(LabelStack configLabels, Serializable key) {
        List<String> overrides = this.getOverrides(key);
        if (overrides != null) {
            for (String configLabel : overrides) {
                configLabels.addLabel(configLabel);
            }
        }
    }

    public void registerColumnOverrides(int columnIndex, String ... configLabels) {
        super.registerOverrides((Serializable)Integer.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverrides(int columnIndex, List<String> configLabels) {
        super.registerOverrides((Serializable)Integer.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverridesOnTop(int columnIndex, String ... configLabels) {
        super.registerOverridesOnTop((Serializable)Integer.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverridesOnTop(int columnIndex, List<String> configLabels) {
        super.registerOverridesOnTop((Serializable)Integer.valueOf(columnIndex), configLabels);
    }

    public void unregisterOverrides(int columnIndex, String configLabel) {
        List<String> overrides = this.getOverrides(Integer.valueOf(columnIndex));
        if (overrides != null) {
            overrides.remove(configLabel);
        }
    }

    public void unregisterOverrides(int columnIndex, String ... configLabels) {
        List<String> overrides = this.getOverrides(Integer.valueOf(columnIndex));
        if (overrides != null) {
            overrides.removeAll(ArrayUtil.asList(configLabels));
        }
    }

    public void registerOverrides(String configLabel) {
        super.registerOverrides((Serializable)((Object)ALL_COLUMN_KEY), configLabel);
    }

    public void registerOverrides(List<String> configLabels) {
        super.registerOverrides((Serializable)((Object)ALL_COLUMN_KEY), configLabels);
    }

    public void registerOverridesOnTop(String configLabel) {
        super.registerOverridesOnTop((Serializable)((Object)ALL_COLUMN_KEY), configLabel);
    }

    public void registerOverridesOnTop(List<String> configLabels) {
        super.registerOverridesOnTop((Serializable)((Object)ALL_COLUMN_KEY), configLabels);
    }

    public void unregisterOverrides(String configLabel) {
        List<String> overrides = this.getOverrides((Serializable)((Object)ALL_COLUMN_KEY));
        if (overrides != null) {
            overrides.remove(configLabel);
            if (overrides.isEmpty()) {
                this.removeOverride((Serializable)((Object)ALL_COLUMN_KEY));
            }
        }
    }

    public void unregisterOverrides(List<String> configLabels) {
        List<String> overrides = this.getOverrides((Serializable)((Object)ALL_COLUMN_KEY));
        if (overrides != null) {
            overrides.removeAll(configLabels);
            if (overrides.isEmpty()) {
                this.removeOverride((Serializable)((Object)ALL_COLUMN_KEY));
            }
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        Map<Serializable, List<String>> overrides = this.getOverrides();
        for (Map.Entry<Serializable, List<String>> entry : overrides.entrySet()) {
            StringBuilder strBuilder = new StringBuilder();
            for (String columnLabel : entry.getValue()) {
                strBuilder.append(columnLabel);
                strBuilder.append(",");
            }
            String propertyValue = strBuilder.toString();
            if (propertyValue.endsWith(",")) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            String propertyKey = String.valueOf(prefix) + PERSISTENCE_KEY + "." + entry.getKey();
            properties.setProperty(propertyKey, propertyValue);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_KEY)) continue;
            String labelsFromPropertyValue = properties.getProperty(keyString).trim();
            String overrideKey = keyString.substring(keyString.lastIndexOf(".") + 1);
            try {
                this.registerColumnOverrides(Integer.parseInt(overrideKey), labelsFromPropertyValue.split(","));
            }
            catch (NumberFormatException numberFormatException) {
                this.registerOverrides((Serializable)((Object)overrideKey), labelsFromPropertyValue.split(","));
            }
        }
    }
}

