/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datatype.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datatype.properties.Messages;
import org.polarsys.capella.core.data.information.datatype.properties.controllers.BooleanTypeController;
import org.polarsys.capella.core.data.information.datatype.properties.sections.DataTypeSection;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleEditableSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleEditableSemanticField;

public class BooleanTypeSection
extends DataTypeSection {
    private SimpleEditableSemanticField defaultValueWidget;

    public BooleanTypeSection() {
        super(false, false);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.defaultValueWidget = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataType.DefaultValueLabel"), this.getWidgetFactory(), Messages.getString("DataType.DefaultValueDefaultName"), (ISimpleEditableSemanticFieldController)new BooleanTypeController()){

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                BooleanTypeSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                BooleanTypeSection.this.refresh();
            }
        };
        this.defaultValueWidget.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.defaultValueWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getBooleanType_OwnedDefaultValue());
        this.evaluateButtonStatus((BooleanType)capellaElement);
    }

    protected void evaluateButtonStatus(BooleanType booleanType) {
        if (booleanType != null) {
            DataValue defaultValue = booleanType.getDefaultValue();
            if (defaultValue == null) {
                this.defaultValueWidget.enableEditButton(false);
            } else {
                this.defaultValueWidget.enableEditButton(true);
            }
        }
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == DatatypePackage.eINSTANCE.getBooleanType();
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.defaultValueWidget);
        return fields;
    }
}

