/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.sequence_message;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_SequenceMessage_InvokedOperation_2
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof SequenceMessage) {
            MessageEnd sntMsgEnd;
            Component sndCpnt = null;
            Component rcvCpnt = null;
            AbstractExchangeItem sndItem = null;
            AbstractExchangeItem rcvItem = null;
            SequenceMessage seqMsg = (SequenceMessage)eObj;
            if (!(seqMsg.eContainer() instanceof Scenario) || ScenarioKind.INTERFACE != ((Scenario)seqMsg.eContainer()).getKind()) {
                return ctx.createSuccessStatus();
            }
            BlockArchitecture rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)seqMsg);
            if (rootBlockArchitecture instanceof OperationalAnalysis) {
                return ctx.createSuccessStatus();
            }
            if (seqMsg.getKind() == MessageKind.REPLY) {
                return ctx.createSuccessStatus();
            }
            AbstractEventOperation invokedOperation = seqMsg.getInvokedOperation();
            if (invokedOperation == null) {
                return ctx.createSuccessStatus();
            }
            MessageEnd rcvMsgEnd = seqMsg.getReceivingEnd();
            if (rcvMsgEnd != null) {
                AbstractType rcvElt;
                AbstractInstance abstractInstance;
                InstanceRole instanceRole;
                Event event = rcvMsgEnd.getEvent();
                if (event instanceof EventReceiptOperation) {
                    EventReceiptOperation evt = (EventReceiptOperation)event;
                    AbstractEventOperation rcvOp = evt.getOperation();
                    rcvItem = this.getExchagneItemFromEvent(rcvOp);
                }
                if ((instanceRole = rcvMsgEnd.getCovered()) != null && (abstractInstance = instanceRole.getRepresentedInstance()) != null && (rcvElt = abstractInstance.getAbstractType()) instanceof Component) {
                    rcvCpnt = (Component)rcvElt;
                }
            }
            if ((sntMsgEnd = seqMsg.getSendingEnd()) != null) {
                AbstractType sndElt;
                AbstractInstance abstractInstance;
                InstanceRole instanceRole;
                Event event = sntMsgEnd.getEvent();
                if (event instanceof EventSentOperation) {
                    EventSentOperation evt = (EventSentOperation)event;
                    AbstractEventOperation sedOp = evt.getOperation();
                    sndItem = this.getExchagneItemFromEvent(sedOp);
                }
                if ((instanceRole = sntMsgEnd.getCovered()) != null && (abstractInstance = instanceRole.getRepresentedInstance()) != null && (sndElt = abstractInstance.getAbstractType()) instanceof Component) {
                    sndCpnt = (Component)sndElt;
                }
            }
            if (sndCpnt == null || rcvCpnt == null) {
                return ctx.createSuccessStatus();
            }
            if (!this.ensureImplementationAndUsage(sndCpnt, sndItem, rcvCpnt, rcvItem)) {
                String sequenceMessageName = EObjectLabelProviderHelper.getText((EObject)seqMsg);
                String sequenceMessageMetaClass = EObjectLabelProviderHelper.getMetaclassLabel((EObject)seqMsg, (boolean)false);
                String scenarioName = EObjectLabelProviderHelper.getText((EObject)seqMsg.eContainer());
                String scenarioMetaClass = EObjectLabelProviderHelper.getMetaclassLabel((EObject)seqMsg.eContainer(), (boolean)false);
                return ctx.createFailureStatus(new Object[]{sequenceMessageName, sequenceMessageMetaClass, scenarioName, scenarioMetaClass});
            }
        }
        return ctx.createSuccessStatus();
    }

    private AbstractExchangeItem getExchagneItemFromEvent(AbstractEventOperation evt) {
        ExchangeItemAllocation itemAllocation;
        ExchangeItem allocatedItem;
        ExchangeItem item = null;
        if (evt instanceof ExchangeItemAllocation && (allocatedItem = (itemAllocation = (ExchangeItemAllocation)evt).getAllocatedItem()) != null) {
            item = allocatedItem;
        }
        return item;
    }

    private boolean ensureImplementationAndUsage(Component sndCpnt_p, AbstractExchangeItem sndItf_p, Component rcvCpnt_p, AbstractExchangeItem rcvItf_p) {
        return this.ensureImplementation(rcvCpnt_p, rcvItf_p) && this.ensureUsage(sndCpnt_p, sndItf_p);
    }

    private boolean ensureImplementation(Component cpnt_p, AbstractExchangeItem itf_p) {
        for (Interface itf : ComponentExt.getAllImplementedAndProvidedInterfaces((Component)cpnt_p)) {
            if (!itf.getExchangeItems().contains((Object)itf_p)) continue;
            return true;
        }
        return false;
    }

    private boolean ensureUsage(Component cpnt_p, AbstractExchangeItem itf_p) {
        for (Interface itf : ComponentExt.getAllUsedAndRequiredInterfaces((Component)cpnt_p)) {
            if (!itf.getExchangeItems().contains((Object)itf_p)) continue;
            return true;
        }
        return false;
    }
}

