/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableExpOperations
extends OCLExpressionOperations {
    protected VariableExpOperations() {
    }

    public static <C, PM> boolean checkVarType(VariableExp<C, PM> variableExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(variableExp, context);
        if (env != null) {
            Variable<C, PM> var = variableExp.getReferredVariable();
            Object type = variableExp.getType();
            if (var != null && type != null && var.getType() != null && !TypeUtil.exactTypeMatch(env, var.getType(), type)) {
                result = false;
                message = OCLMessages.bind(OCLMessages.VariableTypeMismatch_ERROR_, var.getName());
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 39, message, new Object[]{variableExp}));
        }
        return result;
    }
}

