/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.polarsys.capella.common.ui.toolkit.viewers.FieldsViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionControlDecoration;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionDragAndDrop;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionLabelProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionPreferenceOption;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionSourceViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTargetViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTreeNodeContentProvider;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;
import org.polarsys.capella.core.ui.toolkit.decomposition.IDecompositionDataConstants;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;

public class DecompositionGeneralViewer
extends FieldsViewer
implements IDecompositionDataConstants {
    private DecompositionModel _decompositionModel;
    private Button _defaultButton;
    private DialogPage _dialogPage;
    private boolean _isLeftNRight;
    private DecompositionDragAndDrop _sourceDND;
    private TreeViewer _sourceTreeViewer;
    private Text _statusBarText;
    private TreeViewer _targetTreeViewer;
    private DecompositionTargetViewer _targetViewer;
    private boolean isDNDCreated = false;
    protected DecompositionModel model;
    protected Button optionHideTechnicalInterfaces_button;

    public DecompositionGeneralViewer(Composite parent_p, DecompositionModel model_p, boolean leftNRight_p) {
        super(parent_p);
        this._decompositionModel = model_p;
        this._isLeftNRight = leftNRight_p;
        this.model = model_p;
        DecompositionUtil.initializeImages(model_p.getImgRegistry());
        Composite internalComposite = this.createInternalComposite(this.getControl());
        this.createViewer(internalComposite);
        this.createOptions(internalComposite);
    }

    public DecompositionGeneralViewer(Composite parent_p, DecompositionModel model_p, boolean leftNRight_p, boolean syschronizeName, boolean syschronizeDeletion) {
        this(parent_p, model_p, leftNRight_p);
        DecompositionPreferenceOption.synchronizeName = syschronizeName;
        DecompositionPreferenceOption.synchronizeDeletion = syschronizeDeletion;
    }

    public void addSelectionListenerToViewer(TreeViewer viewer_p) {
        viewer_p.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ITreeSelection selection = (ITreeSelection)event_p.getSelection();
                if (!selection.isEmpty() || selection.size() == 1) {
                    DecompositionGeneralViewer.this.updateStatusBar(selection.getFirstElement());
                } else {
                    DecompositionGeneralViewer.this.updateStatusBar(null);
                }
                if (DecompositionGeneralViewer.this._targetViewer != null) {
                    DecompositionGeneralViewer.this._targetViewer.setRemoveTCButtonEnabled(!DecompositionGeneralViewer.this.isDecompositionItemServiceOrDecompositionItemInternalSelected(selection));
                }
            }
        });
    }

    public void addTreeSelectionListener() {
        DecompositionControlDecoration decoration = new DecompositionControlDecoration((Control)this._sourceTreeViewer.getTree(), 16384);
        decoration.setShowOnlyOnFocus(true);
    }

    public void addTreeTipListeners() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._sourceTreeViewer);
    }

    public void createDNDForTargetViewer(CTabFolder folder_p) {
        Decomposition decomposition;
        CTabItem tabItem = folder_p.getSelection();
        TreeViewer viewer = (TreeViewer)tabItem.getData("TARGET_TREEVIEWER");
        if (viewer == null) {
            viewer = this._targetViewer.getTargetTreeViewer();
        }
        if (this.isDNDCreated) {
            this._sourceDND.setTargetViewer(viewer);
        }
        if ((decomposition = (Decomposition)tabItem.getData()) != null) {
            this._decompositionModel.refreshStatus(decomposition);
            this.refreshItems(null);
        }
    }

    protected void createDragDropSourceTargets(TreeViewer targetViewer_p) {
        Tree sourceTree = this._sourceTreeViewer.getTree();
        sourceTree.setData("TREEID", (Object)"SOURCE_TREE");
        Tree targetTree = targetViewer_p.getTree();
        targetTree.setData("TREEID", (Object)"TARGET_TREE");
        if (!this.isDNDCreated) {
            this._sourceDND = new DecompositionDragAndDrop(sourceTree, this._decompositionModel);
            this.isDNDCreated = true;
            this._sourceDND.setSourceViewer(this._sourceTreeViewer);
        }
        DecompositionDragAndDrop dnd = new DecompositionDragAndDrop(targetTree, this._decompositionModel);
        dnd.setSourceViewer(this._sourceTreeViewer);
        dnd.setTargetViewer(targetViewer_p);
        this._sourceDND.setTargetViewer(targetViewer_p);
    }

    protected void createOptions(Composite parent) {
        this.optionHideTechnicalInterfaces_button = new Button(parent, 32);
        this.optionHideTechnicalInterfaces_button.setText(Messages.getString("LCDecompGeneralViewer.hideTechnicalInterfaces"));
        this.optionHideTechnicalInterfaces_button.setSelection(this.model.doesHideTechnicalInterfaces());
        this.optionHideTechnicalInterfaces_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                DecompositionGeneralViewer.this.model.setHideTechnicalInterfaces(((Button)event_p.widget).getSelection());
                DecompositionGeneralViewer.this.refreshItems(DecompositionGeneralViewer.this._targetViewer.getTargetTreeViewer());
            }
        });
    }

    protected Composite createInternalComposite(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void createLeftViewer(Composite composite_p) {
        DecompositionSourceViewer sourceViewer = new DecompositionSourceViewer(composite_p);
        this._sourceTreeViewer = sourceViewer.getSourceTreeViewer();
        sourceViewer.addSourceTreeLightbulbListener();
        this.addSelectionListenerToViewer(this._sourceTreeViewer);
    }

    private void createRightViewer(Composite parent_p) {
        this._targetViewer = new DecompositionTargetViewer(parent_p, this);
        this._targetTreeViewer = this._targetViewer.getTargetTreeViewer();
    }

    private void createStatusTextField(Composite parent_p) {
        this._statusBarText = new Text(parent_p, 2056);
        this._statusBarText.setEditable(false);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        this._statusBarText.setLayoutData((Object)gdData);
    }

    protected void createViewer(Composite parent_p) {
        Composite treeComposite = new Composite(parent_p, 0x1000000);
        treeComposite.setLayout((Layout)new FillLayout(256));
        GridData gdData = new GridData(1808);
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        treeComposite.setLayoutData((Object)gdData);
        this.createLeftViewer(treeComposite);
        if (this._isLeftNRight) {
            this.createRightViewer(treeComposite);
        }
        this.populateTree(this._decompositionModel);
        this.createStatusTextField(parent_p);
    }

    public DecompositionModel getDecompositionModel() {
        return this._decompositionModel;
    }

    public DialogPage getDialogPage() {
        return this._dialogPage;
    }

    public Object getInput() {
        return null;
    }

    private boolean isDecompositionItemServiceOrDecompositionItemInternalSelected(ITreeSelection selection_p) {
        List list = selection_p.toList();
        if (list.isEmpty()) {
            return true;
        }
        for (Object obj : list) {
            if (obj instanceof DecompositionItemService) {
                return true;
            }
            if (!(obj instanceof DecompositionItem) || ((DecompositionItem)obj).isInternal()) continue;
            return true;
        }
        return false;
    }

    private void populateTree(DecompositionModel model_p) {
        int decompSize;
        this._sourceTreeViewer.setLabelProvider((IBaseLabelProvider)new DecompositionLabelProvider(true, this._decompositionModel.getImgRegistry()));
        if (this._isLeftNRight && (decompSize = this._decompositionModel.getDecompositions().size()) > 0) {
            for (Decomposition decomp : this._decompositionModel.getDecompositions()) {
                this._targetViewer.createDecompositionTab(decomp);
                this._targetTreeViewer = this._targetViewer.getTargetTreeViewer();
                this.createDragDropSourceTargets(this._targetTreeViewer);
                this._targetViewer.setDecompositionFieldsEnabled(decompSize);
                model_p.refreshStatus(decomp);
                this.refreshItems(null);
            }
            this._targetViewer.setDefaultSelectedTabIndex();
        }
    }

    public void refreshItems(TreeViewer targetViewer_p) {
        this._sourceTreeViewer.refresh(true);
        this._sourceTreeViewer.setSelection(null, true);
        this._sourceTreeViewer.getTree().notifyListeners(13, new Event());
        if (targetViewer_p != null) {
            targetViewer_p.refresh(true);
            targetViewer_p.setSelection(null, true);
        }
    }

    public void removeDialogFocus() {
        this._dialogPage.getShell().setDefaultButton(null);
    }

    public void setDecompositionModel(DecompositionModel decompositionModel_p) {
        this._decompositionModel = decompositionModel_p;
    }

    public void setDialogFocus() {
        this._dialogPage.getShell().setDefaultButton(this._defaultButton);
    }

    public void setDialogPage(DialogPage dialogPage_p) {
        this._dialogPage = dialogPage_p;
        this._defaultButton = this._dialogPage.getShell().getDefaultButton();
        this.removeDialogFocus();
    }

    public void setInput(Object input_p) {
    }

    public void setSourceTreeContentProvider(boolean isSynthesisCheckPage_p) {
        this._sourceTreeViewer.setContentProvider((IContentProvider)new DecompositionTreeNodeContentProvider(this.model, isSynthesisCheckPage_p));
        this._sourceTreeViewer.setInput((Object)this._decompositionModel);
    }

    public void showErrorMessage(String message) {
        this._dialogPage.setErrorMessage(message);
    }

    protected void updateStatusBar(Object element_p) {
        if (this._statusBarText == null) {
            return;
        }
        if (element_p instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)element_p;
            String path = item.getPath();
            this._statusBarText.setText(path == null ? "" : path);
            if (this._targetViewer != null) {
                this._targetViewer.setDetachInterfaceButtonEnabled(!item.getParentComponent().isReusedComponent());
            }
        } else if (element_p instanceof DecompositionComponent) {
            String str = ((DecompositionComponent)element_p).getPath();
            this._statusBarText.setText(str == null ? "" : str);
        } else if (element_p instanceof DecompositionItemService) {
            DecompositionItemService item = (DecompositionItemService)element_p;
            String name = item.getPath();
            this._statusBarText.setText(name == null ? "" : name);
        } else {
            this._statusBarText.setText("");
        }
    }
}

