/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.ctx.validation.system;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.SystemRealization;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_System_Realization
extends AbstractValidationRule {
    private static final String UNNAMED_ELEMENT = "Unnamed Element";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof System) {
            System system = (System)eObj;
            for (AbstractTrace trace : system.getIncomingTraces()) {
                if (!(trace instanceof SystemRealization)) continue;
                TraceableElement sourceElement = trace.getSourceElement();
                TraceableElement targetElement = trace.getTargetElement();
                if (sourceElement instanceof LogicalComponent && targetElement instanceof System) continue;
                String sourceName = UNNAMED_ELEMENT;
                if (sourceElement instanceof NamedElement) {
                    sourceName = ((NamedElement)sourceElement).getName();
                }
                String sourceType = sourceElement.eClass().getName();
                String targetName = UNNAMED_ELEMENT;
                if (targetElement instanceof NamedElement) {
                    targetName = ((NamedElement)targetElement).getName();
                }
                String targetType = targetElement.eClass().getName();
                return this.createFailureStatus(ctx, new Object[]{sourceName, sourceType, targetName, targetType});
            }
        }
        return ctx.createSuccessStatus();
    }
}

