/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocator;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.helpers.cs.delegates.InterfaceAllocatorHelper;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionalBlockHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.CommunicationLinkExchangerHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.PartitionableElementHelper;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;

public class ComponentHelper {
    private static ComponentHelper instance;

    private ComponentHelper() {
    }

    public static ComponentHelper getInstance() {
        if (instance == null) {
            instance = new ComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(Component element, EStructuralFeature feature) {
        List<Interface> ret = null;
        if (feature.equals(CsPackage.Literals.COMPONENT__ALLOCATED_COMPONENTS)) {
            ret = this.getAllocatedComponents(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__ALLOCATING_COMPONENTS)) {
            ret = this.getAllocatingComponents(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__PROVISIONED_COMPONENT_ALLOCATIONS)) {
            ret = this.getProvisionedComponentAllocations(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__PROVISIONING_COMPONENT_ALLOCATIONS)) {
            ret = this.getProvisioningComponentAllocations(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__PROVIDED_INTERFACES)) {
            ret = this.getProvidedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__REQUIRED_INTERFACES)) {
            ret = this.getRequiredInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__IMPLEMENTED_INTERFACES)) {
            ret = this.getImplementedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__USED_INTERFACES)) {
            ret = this.getUsedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__IMPLEMENTED_INTERFACE_LINKS)) {
            ret = this.getImplementedInterfaceLinks(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__USED_INTERFACE_LINKS)) {
            ret = this.getUsedInterfaceLinks(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_COMPONENT_PORTS)) {
            ret = this.getContainedComponentPorts(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_PARTS)) {
            ret = this.getContainedParts(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_PHYSICAL_PORTS)) {
            ret = this.getContainedPhysicalPorts(element);
        }
        if (ret == null) {
            ret = AbstractFunctionalBlockHelper.getInstance().doSwitch((AbstractFunctionalBlock)element, feature);
        }
        if (ret == null) {
            ret = InterfaceAllocatorHelper.getInstance().doSwitch((InterfaceAllocator)element, feature);
        }
        if (ret == null) {
            ret = PartitionableElementHelper.getInstance().doSwitch((PartitionableElement)element, feature);
        }
        if (ret == null) {
            ret = CommunicationLinkExchangerHelper.getInstance().doSwitch((CommunicationLinkExchanger)element, feature);
        }
        return ret;
    }

    protected List<ComponentAllocation> getProvisionedComponentAllocations(Component element) {
        ArrayList<ComponentAllocation> ret = new ArrayList<ComponentAllocation>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof ComponentAllocation)) continue;
            ret.add((ComponentAllocation)trace);
        }
        return ret;
    }

    protected List<ComponentAllocation> getProvisioningComponentAllocations(Component element) {
        ArrayList<ComponentAllocation> ret = new ArrayList<ComponentAllocation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof ComponentAllocation)) continue;
            ret.add((ComponentAllocation)trace);
        }
        return ret;
    }

    protected List<Component> getAllocatedComponents(Component element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            Component cpnt = componentAllocation.getAllocatedComponent();
            if (cpnt == null) continue;
            ret.add(cpnt);
        }
        return ret;
    }

    protected List<Component> getAllocatingComponents(Component element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (ComponentAllocation componentAllocation : element.getProvisioningComponentAllocations()) {
            Component cpnt = componentAllocation.getAllocatingComponent();
            if (cpnt == null) continue;
            ret.add(cpnt);
        }
        return ret;
    }

    protected List<Interface> getProvidedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Partition partition : element.getOwnedPartitions()) {
            if (!(partition instanceof ComponentPort)) continue;
            ret.addAll((Collection<Interface>)((ComponentPort)partition).getProvidedInterfaces());
        }
        return ret;
    }

    protected List<Interface> getRequiredInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Partition partition : element.getOwnedPartitions()) {
            if (!(partition instanceof ComponentPort)) continue;
            ret.addAll((Collection<Interface>)((ComponentPort)partition).getRequiredInterfaces());
        }
        return ret;
    }

    protected List<InterfaceImplementation> getImplementedInterfaceLinks(Component element) {
        return element.getOwnedInterfaceImplementations();
    }

    protected List<InterfaceUse> getUsedInterfaceLinks(Component element) {
        return element.getOwnedInterfaceUses();
    }

    protected List<Interface> getImplementedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceImplementation interfaceImplementation : element.getImplementedInterfaceLinks()) {
            Interface itf = interfaceImplementation.getImplementedInterface();
            if (itf == null) continue;
            ret.add(itf);
        }
        return ret;
    }

    protected List<Interface> getUsedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceUse interfaceUse : element.getUsedInterfaceLinks()) {
            Interface itf = interfaceUse.getUsedInterface();
            if (itf == null) continue;
            ret.add(itf);
        }
        return ret;
    }

    protected List<ComponentPort> getContainedComponentPorts(Component element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof ComponentPort)) continue;
            ret.add((ComponentPort)feature);
        }
        return ret;
    }

    protected List<Part> getContainedParts(Component element) {
        ArrayList<Part> ret = new ArrayList<Part>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof Part)) continue;
            ret.add((Part)feature);
        }
        return ret;
    }

    protected List<PhysicalPort> getContainedPhysicalPorts(Component element) {
        ArrayList<PhysicalPort> ret = new ArrayList<PhysicalPort>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof PhysicalPort)) continue;
            ret.add((PhysicalPort)feature);
        }
        return ret;
    }
}

