/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.ActorMissionInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.OperationalActorRealization;
import org.polarsys.capella.core.data.ctx.OperationalEntityRealization;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractActorHelper;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActor;

public class ActorHelper {
    private static ActorHelper instance;

    private ActorHelper() {
    }

    public static ActorHelper getInstance() {
        if (instance == null) {
            instance = new ActorHelper();
        }
        return instance;
    }

    public Object doSwitch(Actor element, EStructuralFeature feature) {
        List<ActorMissionInvolvement> ret = null;
        if (feature.equals(CtxPackage.Literals.ACTOR__PARTICIPATIONS_IN_CAPABILITIES)) {
            ret = this.getParticipationsInCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__PARTICIPATIONS_IN_CAPABILITY_REALIZATIONS)) {
            ret = this.getParticipationsInCapabilityRealizations(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__PARTICIPATIONS_IN_MISSIONS)) {
            ret = this.getParticipationsInMissions(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__CONTRIBUTED_MISSIONS)) {
            ret = this.getContributedMissions(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__CONTRIBUTED_CAPABILITIES)) {
            ret = this.getContributedCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__ALLOCATED_SYSTEM_FUNCTIONS)) {
            ret = this.getAllocatedSystemFunctions(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__REALIZING_LOGICAL_ACTORS)) {
            ret = this.getRealizingLogicalActors(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__REALIZED_OPERATIONAL_ACTORS)) {
            ret = this.getRealizedOperationalActors(element);
        } else if (feature.equals(CtxPackage.Literals.ACTOR__REALIZED_ENTITIES)) {
            ret = this.getRealizedEntities(element);
        }
        if (ret == null) {
            ret = AbstractActorHelper.getInstance().doSwitch((AbstractActor)element, feature);
        }
        return ret;
    }

    protected List<ActorCapabilityInvolvement> getParticipationsInCapabilities(Actor element) {
        ArrayList<ActorCapabilityInvolvement> ret = new ArrayList<ActorCapabilityInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof ActorCapabilityInvolvement)) continue;
            ret.add((ActorCapabilityInvolvement)involvement);
        }
        return ret;
    }

    protected List<ActorCapabilityRealizationInvolvement> getParticipationsInCapabilityRealizations(Actor element) {
        ArrayList<ActorCapabilityRealizationInvolvement> ret = new ArrayList<ActorCapabilityRealizationInvolvement>();
        for (CapabilityRealizationInvolvement involvement : element.getInvolvingCapabilityRealizationInvolvements()) {
            if (!(involvement instanceof ActorCapabilityRealizationInvolvement)) continue;
            ret.add((ActorCapabilityRealizationInvolvement)involvement);
        }
        return ret;
    }

    protected List<ActorMissionInvolvement> getParticipationsInMissions(Actor element) {
        ArrayList<ActorMissionInvolvement> ret = new ArrayList<ActorMissionInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof ActorMissionInvolvement)) continue;
            ret.add((ActorMissionInvolvement)involvement);
        }
        return ret;
    }

    protected List<Capability> getContributedCapabilities(Actor element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (ActorCapabilityInvolvement involvement : element.getParticipationsInCapabilities()) {
            Capability capa = involvement.getCapability();
            if (capa == null) continue;
            ret.add(capa);
        }
        return ret;
    }

    protected List<Mission> getContributedMissions(Actor element) {
        ArrayList<Mission> ret = new ArrayList<Mission>();
        for (ActorMissionInvolvement involvement : element.getParticipationsInMissions()) {
            Mission mission = involvement.getMission();
            if (mission == null) continue;
            ret.add(mission);
        }
        return ret;
    }

    protected List<SystemFunction> getAllocatedSystemFunctions(Actor element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof SystemFunction)) continue;
            ret.add((SystemFunction)function);
        }
        return ret;
    }

    protected List<LogicalActor> getRealizingLogicalActors(Actor element) {
        ArrayList<LogicalActor> ret = new ArrayList<LogicalActor>();
        for (Component cpnt : element.getAllocatingComponents()) {
            if (!(cpnt instanceof LogicalActor)) continue;
            ret.add((LogicalActor)cpnt);
        }
        return ret;
    }

    protected List<OperationalActor> getRealizedOperationalActors(Actor element) {
        ArrayList<OperationalActor> ret = new ArrayList<OperationalActor>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Component cpnt;
            if (!(trace instanceof OperationalActorRealization) || !((cpnt = ((OperationalActorRealization)trace).getAllocatedComponent()) instanceof OperationalActor)) continue;
            ret.add((OperationalActor)cpnt);
        }
        return ret;
    }

    protected List<Entity> getRealizedEntities(Actor element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Component cpnt;
            if (!(trace instanceof OperationalEntityRealization) || !((cpnt = ((OperationalEntityRealization)trace).getAllocatedComponent()) instanceof Entity) || cpnt instanceof OperationalActor) continue;
            ret.add((Entity)cpnt);
        }
        return ret;
    }
}

