/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorMissionInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemMissionInvolvement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolverElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;

public class MissionHelper {
    private static MissionHelper instance;

    private MissionHelper() {
    }

    public static MissionHelper getInstance() {
        if (instance == null) {
            instance = new MissionHelper();
        }
        return instance;
    }

    public Object doSwitch(Mission element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CtxPackage.Literals.MISSION__INVOLVED_ACTORS)) {
            ret = this.getInvolvedActors(element);
        } else if (feature.equals(CtxPackage.Literals.MISSION__INVOLVED_SYSTEM)) {
            ret = this.getInvolvedSystem(element);
        } else if (feature.equals(CtxPackage.Literals.MISSION__PARTICIPATING_ACTORS)) {
            ret = this.getParticipatingActors(element);
        } else if (feature.equals(CtxPackage.Literals.MISSION__PARTICIPATING_SYSTEM)) {
            ret = this.getParticipatingSystem(element);
        } else if (feature.equals(CtxPackage.Literals.MISSION__EXPLOITED_CAPABILITIES)) {
            ret = this.getExploitedCapabilities(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = InvolverElementHelper.getInstance().doSwitch((InvolverElement)element, feature);
        }
        return ret;
    }

    protected List<ActorMissionInvolvement> getInvolvedActors(Mission element) {
        EList involvements = element.getInvolvedInvolvements();
        ArrayList<ActorMissionInvolvement> ret = new ArrayList<ActorMissionInvolvement>();
        for (Involvement involvement : involvements) {
            if (!(involvement instanceof ActorMissionInvolvement)) continue;
            ret.add((ActorMissionInvolvement)involvement);
        }
        return ret;
    }

    protected SystemMissionInvolvement getInvolvedSystem(Mission element) {
        return element.getOwnedSystemMissionInvolvement();
    }

    protected List<Capability> getExploitedCapabilities(Mission element) {
        EList exploitations = element.getOwnedCapabilityExploitations();
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (CapabilityExploitation exploitation : exploitations) {
            Capability capa = exploitation.getCapability();
            if (capa == null) continue;
            ret.add(capa);
        }
        return ret;
    }

    protected System getParticipatingSystem(Mission element) {
        SystemMissionInvolvement involvement = element.getOwnedSystemMissionInvolvement();
        if (involvement != null) {
            return involvement.getSystem();
        }
        return null;
    }

    protected List<Actor> getParticipatingActors(Mission element) {
        EList involvements = element.getInvolvedActors();
        ArrayList<Actor> ret = new ArrayList<Actor>();
        for (ActorMissionInvolvement involvement : involvements) {
            Actor actor = involvement.getActor();
            if (actor == null) continue;
            ret.add(actor);
        }
        return ret;
    }
}

