/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.polarsys.kitalpha.massactions.core.column.AbstractMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.painter.cell.TextAndLabelImagePainter;
import org.polarsys.kitalpha.massactions.visualize.query.IQuery;

public class QueryColumn
extends AbstractMAColumn {
    protected IQuery query;
    protected List<String> parameterColumnNames;

    public void setParameterColumnPositions(int[] parameterColumnPositions) {
        ArrayList<String> columnNames = new ArrayList<String>();
        SelectionLayer selectionLayer = this.bodyLayer.getSelectionLayer();
        IMAColumnPropertyAccessor columnPropertyAccessor = this.bodyLayer.getColumnPropertyAccessor();
        int i = 0;
        while (i < parameterColumnPositions.length) {
            int position = parameterColumnPositions[i];
            int index = selectionLayer.getColumnIndexByPosition(position);
            String columnName = columnPropertyAccessor.getColumnProperty(index);
            columnNames.add(columnName);
            ++i;
        }
        this.setParameterColumnNames(columnNames);
    }

    public void setParameterColumnNames(List<String> parameterColumnNames) {
        this.parameterColumnNames = parameterColumnNames;
    }

    public void setParameterColumnNames(String ... parameterColumnNames) {
        this.setParameterColumnNames(Arrays.asList(parameterColumnNames));
    }

    protected ICellPainter createCellPainter() {
        return new TextAndLabelImagePainter();
    }

    public Object getDataValue(EObject rowObject) {
        IMAColumnPropertyAccessor columnPropertyAccessor = this.bodyLayer.getColumnPropertyAccessor();
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (String parameterColumnName : this.parameterColumnNames) {
            int parameterColumnIndex = columnPropertyAccessor.getColumnIndex(parameterColumnName);
            if (parameterColumnIndex == -1) {
                return "undefined";
            }
            Object parameterColumnValue = columnPropertyAccessor.getDataValue((Object)rowObject, parameterColumnIndex);
            parameterValues.add(parameterColumnValue);
        }
        this.query.setParameterValues(parameterValues);
        this.query.setTarget(rowObject);
        return this.query.evaluate();
    }

    public void setQuery(IQuery query) {
        this.query = query;
    }

    public void setDataValue(EObject rowObject, Object newValue) {
    }

    public void dataChanged(Collection<EObject> newData) {
    }
}

