/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;

public class TimeLapseHelper {
    private static List<EStructuralFeature> BOUNDS = null;

    public static List<TimeLapse> getTimeLapseOfType(Scenario sc, EClass eclass) throws MergeToolException {
        ArrayList<TimeLapse> result = new ArrayList<TimeLapse>();
        if (sc == null || !InteractionPackage.Literals.TIME_LAPSE.isSuperTypeOf(eclass)) {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        for (TimeLapse tl : sc.getOwnedTimeLapses()) {
            if (!tl.eClass().equals(eclass)) continue;
            result.add(tl);
        }
        return result;
    }

    public static TimeLapse isAnyTimeLapseUseThisIfrag(Scenario sc, InteractionFragment ifrag) throws MergeToolException {
        TimeLapse result = null;
        if (!ifrag.eContainer().equals(sc)) {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        Object target = null;
        for (TimeLapse tl : sc.getOwnedTimeLapses()) {
            for (EStructuralFeature feature : TimeLapseHelper.getBoundFeaturesList()) {
                target = tl.eGet(feature);
                if (target == null || !target.equals(ifrag)) continue;
                result = tl;
                break;
            }
            if (result != null) break;
        }
        return result;
    }

    public static EStructuralFeature returnPositionOn(TimeLapse tl, InteractionFragment ifrag) throws MergeToolException {
        EStructuralFeature result = null;
        if (tl == null || ifrag == null) {
            throw new MergeToolException(MergeMessages.genericToolError);
        }
        for (EStructuralFeature feature : TimeLapseHelper.getBoundFeaturesList()) {
            if (!tl.eGet(feature).equals(ifrag)) continue;
            result = feature;
            break;
        }
        return result;
    }

    public static CombinedFragment getCombinedFragment(InteractionOperand io) {
        CombinedFragment result = null;
        try {
            Scenario scenario = (Scenario)io.eContainer();
            CombinedFragment current = null;
            List<TimeLapse> combinedFragments = TimeLapseHelper.getTimeLapseOfType(scenario, InteractionPackage.Literals.COMBINED_FRAGMENT);
            for (TimeLapse tl : combinedFragments) {
                current = (CombinedFragment)tl;
                if (!current.getReferencedOperands().contains((Object)io)) continue;
                result = current;
                break;
            }
        }
        catch (MergeToolException mergeToolException) {
            // empty catch block
        }
        return result;
    }

    public static List<EStructuralFeature> getBoundFeaturesList() {
        if (BOUNDS == null) {
            BOUNDS = new ArrayList<EStructuralFeature>();
            BOUNDS.add((EStructuralFeature)InteractionPackage.Literals.TIME_LAPSE__START);
            BOUNDS.add((EStructuralFeature)InteractionPackage.Literals.TIME_LAPSE__FINISH);
        }
        return BOUNDS;
    }
}

