/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IWorkbenchAdapter wbadapter;
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return Messages.format(JavaUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof IJavaElement) {
                return this.formatJavaElementMessage((IJavaElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof PackageFragmentRootContainer) {
                PackageFragmentRootContainer container = (PackageFragmentRootContainer)elem;
                return String.valueOf(container.getLabel()) + JavaElementLabels.CONCAT_STRING + container.getJavaProject().getElementName();
            }
            if (elem instanceof IJarEntryResource) {
                IJarEntryResource jarEntryResource = (IJarEntryResource)elem;
                StringBuffer buf = new StringBuffer(BasicElementLabels.getResourceName((String)jarEntryResource.getName()));
                buf.append(JavaElementLabels.CONCAT_STRING);
                IPath fullPath = jarEntryResource.getFullPath();
                if (fullPath.segmentCount() > 1) {
                    buf.append(BasicElementLabels.getPathLabel((IPath)fullPath.removeLastSegments(1), (boolean)false));
                    buf.append(JavaElementLabels.CONCAT_STRING);
                }
                buf.append(JavaElementLabels.getElementLabel((IJavaElement)jarEntryResource.getPackageFragmentRoot(), 0x40000000000L));
                return buf.toString();
            }
            if (elem instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)elem).getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbadapter.getLabel(elem);
            }
        }
        return "";
    }

    private String formatJavaElementMessage(IJavaElement element) {
        return JavaElementLabels.getElementLabel(element, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(BasicElementLabels.getResourceName((String)element.getName())) + JavaElementLabels.CONCAT_STRING + BasicElementLabels.getPathLabel((IPath)parent.getFullPath(), (boolean)false);
        }
        return BasicElementLabels.getResourceName((String)element.getName());
    }
}

