/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.AddGetterSetterOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.IRequestQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddGetterSetterAction
extends SelectionDispatchAction {
    private boolean fSort;
    private boolean fSynchronized;
    private boolean fFinal;
    private int fVisibility;
    private boolean fGenerateComment;
    private int fNumEntries;
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.AddGetterSetterAction_error_title;

    public AddGetterSetterAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddGetterSetterAction_label);
        this.setDescription(ActionMessages.AddGetterSetterAction_description);
        this.setToolTipText(ActionMessages.AddGetterSetterAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.getter_setter_action_context");
    }

    public AddGetterSetterAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
        this.fEditor.getEditorSite();
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (this.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.AddGetterSetterAction_no_primary_type_title, (String)ActionMessages.AddGetterSetterAction_no_primary_type_message);
                    this.notifyResult(false);
                    return;
                }
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isAnonymous();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields == null || fields.length == 0) {
            return false;
        }
        int count = 0;
        int index = 0;
        while (index < fields.length) {
            if (!JdtFlags.isEnum((IMember)fields[index])) {
                ++count;
            }
            ++index;
        }
        if (count == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_not_applicable);
        }
        return count > 0;
    }

    private void resetNumEntries() {
        this.fNumEntries = 0;
    }

    private void incNumEntries() {
        ++this.fNumEntries;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (type.isAnnotation()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_annotation_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_interface_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.getCompilationUnit() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_error_not_in_source_file);
            this.notifyResult(false);
            return;
        }
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            this.notifyResult(false);
            return;
        }
        if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)type)) {
            this.notifyResult(false);
            return;
        }
        AddGetterSetterLabelProvider lp = new AddGetterSetterLabelProvider();
        this.resetNumEntries();
        Map<IField, GetterSetterEntry[]> entries = this.createGetterSetterMapping(type);
        if (entries.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGettSetterAction_typeContainsNoFields_message);
            this.notifyResult(false);
            return;
        }
        AddGetterSetterContentProvider cp = new AddGetterSetterContentProvider(entries);
        GetterSetterTreeSelectionDialog dialog = new GetterSetterTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, cp, this.fEditor, type);
        dialog.setComparator(new JavaElementComparator());
        dialog.setTitle(DIALOG_TITLE);
        String message = ActionMessages.AddGetterSetterAction_dialog_label;
        dialog.setMessage(message);
        dialog.setValidator(AddGetterSetterAction.createValidator(this.fNumEntries));
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(type);
        if (preselected.length > 0) {
            dialog.setInitialSelections(preselected);
            dialog.setExpandedElements(preselected);
        }
        LinkedHashSet<IField> keySet = new LinkedHashSet<IField>(entries.keySet());
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IField[] getterSetterFields;
            IField[] setterFields;
            IField[] getterFields;
            Object[] result = dialog.getResult();
            if (result == null) {
                this.notifyResult(false);
                return;
            }
            this.fSort = dialog.getSortOrder();
            this.fSynchronized = dialog.getSynchronized();
            this.fFinal = dialog.getFinal();
            this.fVisibility = dialog.getVisibilityModifier();
            this.fGenerateComment = dialog.getGenerateComment();
            if (this.fSort) {
                getterFields = AddGetterSetterAction.getGetterFields(result, keySet);
                setterFields = AddGetterSetterAction.getSetterFields(result, keySet);
                getterSetterFields = new IField[]{};
            } else {
                getterFields = AddGetterSetterAction.getGetterOnlyFields(result, keySet);
                setterFields = AddGetterSetterAction.getSetterOnlyFields(result, keySet);
                getterSetterFields = AddGetterSetterAction.getGetterSetterFields(result, keySet);
            }
            this.generate(type, getterFields, setterFields, getterSetterFields, new RefactoringASTParser(9).parse((ITypeRoot)type.getCompilationUnit(), true), dialog.getElementPosition());
        }
        this.notifyResult(dialogResult == 0);
    }

    private static String createSignatureKey(String methodName, IField field) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodName);
        String fieldType = field.getTypeSignature();
        String signature = Signature.getSimpleName((String)Signature.toString((String)fieldType));
        buffer.append("#");
        buffer.append(signature);
        return buffer.toString();
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddGetterSetterSelectionStatusValidator validator = new AddGetterSetterSelectionStatusValidator(entries);
        return validator;
    }

    private static IField[] getSetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (!entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                }
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterOnlyFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    list.add(entry.field);
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.remove(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getSetterOnlyFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && !getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static IField[] getGetterSetterFields(Object[] result, Set<IField> set) {
        List<IField> list = new ArrayList<IField>(0);
        Object each = null;
        GetterSetterEntry entry = null;
        boolean getterSet = false;
        int i = 0;
        while (i < result.length) {
            each = result[i];
            if (each instanceof GetterSetterEntry) {
                entry = (GetterSetterEntry)each;
                if (entry.isGetter) {
                    getterSet = true;
                }
                if (!entry.isGetter && getterSet) {
                    list.add(entry.field);
                    getterSet = false;
                }
            } else {
                getterSet = false;
            }
            ++i;
        }
        list = AddGetterSetterAction.reorderFields(list, set);
        return list.toArray(new IField[list.size()]);
    }

    private static List<IField> reorderFields(List<IField> collection, Set<IField> set) {
        ArrayList<IField> list = new ArrayList<IField>(collection.size());
        for (IField field : set) {
            if (!collection.contains(field)) continue;
            list.add(field);
        }
        return list;
    }

    private void generate(IType type, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, CompilationUnit unit, IJavaElement elementPosition) throws CoreException {
        if (getterFields.length == 0 && setterFields.length == 0 && getterSetterFields.length == 0) {
            return;
        }
        ICompilationUnit cu = null;
        cu = getterFields.length != 0 ? getterFields[0].getCompilationUnit() : (setterFields.length != 0 ? setterFields[0].getCompilationUnit() : getterSetterFields[0].getCompilationUnit());
        this.run(cu, type, getterFields, setterFields, getterSetterFields, JavaUI.openInEditor((IJavaElement)cu), unit, elementPosition);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IType type;
            if (!ActionUtil.isProcessable(this.fEditor)) {
                this.notifyResult(false);
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.AddGetterSetterAction_not_applicable);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.AddGetterSetterAction_error_actionfailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(ICompilationUnit cu, IType type, IField[] getterFields, IField[] setterFields, IField[] getterSetterFields, IEditorPart editor, CompilationUnit unit, IJavaElement elementPosition) {
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        try {
            try {
                void var12_16;
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
                settings.createComments = this.fGenerateComment;
                AddGetterSetterOperation op = new AddGetterSetterOperation(type, getterFields, setterFields, getterSetterFields, unit, this.skipReplaceQuery(), elementPosition, settings, true, false);
                this.setOperationStatusFields(op);
                IWorkbenchWindow iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)var12_16, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getSchedulingRule()), op.getSchedulingRule());
                return;
            }
            catch (InvocationTargetException e) {
                String message = ActionMessages.AddGetterSetterAction_error_actionfailed;
                ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, message);
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
            catch (InterruptedException interruptedException) {
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private void setOperationStatusFields(AddGetterSetterOperation op) {
        int flags = this.fVisibility;
        if (this.fSynchronized) {
            flags |= 0x20;
        }
        if (this.fFinal) {
            flags |= 0x10;
        }
        op.setSort(this.fSort);
        op.setVisibility(flags);
    }

    private IRequestQuery skipReplaceQuery() {
        return new IRequestQuery(){

            @Override
            public int doQuery(IMember method) {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 3;
                int[] returnCodes = nArray;
                String skipLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_skip_label;
                String replaceLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_replace_label;
                String skipAllLabel = ActionMessages.AddGetterSetterAction_SkipExistingDialog_skipAll_label;
                String[] options = new String[]{skipLabel, replaceLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
                String methodName = JavaElementLabels.getElementLabel((IJavaElement)method, 1L);
                String formattedMessage = Messages.format(ActionMessages.AddGetterSetterAction_SkipExistingDialog_message, BasicElementLabels.getJavaElementName((String)methodName));
                return AddGetterSetterAction.this.showQueryDialog(formattedMessage, options, returnCodes);
            }
        };
    }

    private int showQueryDialog(final String message, final String[] buttonLabels, int[] returnCodes) {
        final Shell shell = this.getShell();
        if (shell == null) {
            JavaPlugin.logErrorMessage("AddGetterSetterAction.showQueryDialog: No active shell found");
            return 0;
        }
        final int[] result = new int[]{1};
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String title = ActionMessages.AddGetterSetterAction_QueryDialog_title;
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttonLabels, 0);
                result[0] = dialog.open();
            }
        });
        int returnVal = result[0];
        return returnVal < 0 ? 0 : returnCodes[returnVal];
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            IType declaringType = fld.getDeclaringType();
                            if (declaringType.isInterface() || declaringType.isAnonymous()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
                ++i;
            }
            return res;
        }
        return null;
    }

    private Map<IField, GetterSetterEntry[]> createGetterSetterMapping(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        LinkedHashMap<IField, GetterSetterEntry[]> result = new LinkedHashMap<IField, GetterSetterEntry[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            int flags = field.getFlags();
            if (!Flags.isEnum((int)flags)) {
                ArrayList<GetterSetterEntry> l = new ArrayList<GetterSetterEntry>(2);
                if (GetterSetterUtil.getGetter(field) == null) {
                    l.add(new GetterSetterEntry(field, true, Flags.isFinal((int)flags)));
                    this.incNumEntries();
                }
                if (GetterSetterUtil.getSetter(field) == null) {
                    l.add(new GetterSetterEntry(field, false, Flags.isFinal((int)flags)));
                    this.incNumEntries();
                }
                if (!l.isEmpty()) {
                    result.put(field, l.toArray(new GetterSetterEntry[l.size()]));
                }
            }
            ++i;
        }
        return result;
    }

    private static class AddGetterSetterContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private Map<IField, GetterSetterEntry[]> fGetterSetterEntries;

        public AddGetterSetterContentProvider(Map<IField, GetterSetterEntry[]> entries) {
            this.fGetterSetterEntries = entries;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return this.fGetterSetterEntries.get(parentElement);
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IMember) {
                return ((IMember)element).getDeclaringType();
            }
            if (element instanceof GetterSetterEntry) {
                return ((GetterSetterEntry)element).field;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fGetterSetterEntries.keySet().toArray();
        }

        public void dispose() {
            this.fGetterSetterEntries.clear();
            this.fGetterSetterEntries = null;
        }
    }

    private static class AddGetterSetterLabelProvider
    extends JavaElementLabelProvider {
        AddGetterSetterLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)element;
                try {
                    if (entry.isGetter) {
                        return String.valueOf(GetterSetterUtil.getGetterName(entry.field, null)) + "()";
                    }
                    return String.valueOf(GetterSetterUtil.getSetterName(entry.field, null)) + '(' + Signature.getSimpleName((String)Signature.toString((String)entry.field.getTypeSignature())) + ')';
                }
                catch (JavaModelException javaModelException) {
                    return "";
                }
            }
            return super.getText(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof GetterSetterEntry) {
                int flags = 0;
                try {
                    flags = ((GetterSetterEntry)element).field.getFlags();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                Object desc = JavaElementImageProvider.getFieldImageDescriptor(false, 1);
                int adornmentFlags = Flags.isStatic((int)flags) ? 8 : 0;
                desc = new JavaElementImageDescriptor((ImageDescriptor)desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
            return super.getImage(element);
        }
    }

    private static class AddGetterSetterSelectionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddGetterSetterSelectionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            HashSet<Object> map = null;
            if (selection != null && selection.length > 1) {
                map = new HashSet<Object>(selection.length);
            }
            int selectedCount = 0;
            int possibleDuplicateCount = 0;
            int i = 0;
            while (i < selection.length) {
                try {
                    if (selection[i] instanceof GetterSetterEntry) {
                        Object key = selection[i];
                        IField getsetField = ((GetterSetterEntry)selection[i]).field;
                        if (((GetterSetterEntry)selection[i]).isGetter) {
                            if (!map.add(GetterSetterUtil.getGetterName(getsetField, null))) {
                                ++possibleDuplicateCount;
                            }
                        } else {
                            key = AddGetterSetterAction.createSignatureKey(GetterSetterUtil.getSetterName(getsetField, null), getsetField);
                            if (!map.add(key)) {
                                ++possibleDuplicateCount;
                            }
                        }
                        ++selectedCount;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
            if (possibleDuplicateCount > 0) {
                return new StatusInfo(2, possibleDuplicateCount == 1 ? ActionMessages.AddGetterSetterAction_error_duplicate_methods_singular : Messages.format(ActionMessages.AddGetterSetterAction_error_duplicate_methods_plural, String.valueOf(possibleDuplicateCount)));
            }
            if (selectedCount == 0) {
                return new StatusInfo(4, "");
            }
            String message = Messages.format(ActionMessages.AddGetterSetterAction_methods_selected, new Object[]{String.valueOf(selectedCount), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }
    }

    private static class GetterSetterEntry {
        public final IField field;
        public final boolean isGetter;
        public final boolean isFinal;

        GetterSetterEntry(IField field, boolean isGetterEntry, boolean isFinal) {
            this.field = field;
            this.isGetter = isGetterEntry;
            this.isFinal = isFinal;
        }
    }

    private static class GetterSetterTreeSelectionDialog
    extends SourceActionDialog {
        private AddGetterSetterContentProvider fContentProvider;
        private static final int SELECT_GETTERS_ID = 1025;
        private static final int SELECT_SETTERS_ID = 1026;
        private final String SETTINGS_SECTION = "AddGetterSetterDialog";
        private final String SORT_ORDER = "SortOrdering";
        private final String ALLOW_SETTERS_FOR_FINALS = "RemoveFinal";
        private IDialogSettings fSettings;
        private SettersForFinalFieldsFilter fSettersForFinalFieldsFilter;
        private boolean fSortOrder;
        private boolean fAllowSettersForFinals;
        private ArrayList<GetterSetterEntry> fPreviousSelectedFinals;

        public GetterSetterTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, AddGetterSetterContentProvider contentProvider, CompilationUnitEditor editor, IType type) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, false);
            this.fContentProvider = contentProvider;
            this.fPreviousSelectedFinals = new ArrayList();
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("AddGetterSetterDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("AddGetterSetterDialog");
                this.fSettings.put("SortOrdering", false);
                this.fSettings.put("RemoveFinal", false);
            }
            this.fSortOrder = this.fSettings.getBoolean("SortOrdering");
            this.fAllowSettersForFinals = this.fSettings.getBoolean("RemoveFinal");
            this.fSettersForFinalFieldsFilter = new SettersForFinalFieldsFilter(contentProvider);
        }

        public boolean getSortOrder() {
            return this.fSortOrder;
        }

        public void setSortOrder(boolean sort) {
            if (this.fSortOrder != sort) {
                this.fSortOrder = sort;
                this.fSettings.put("SortOrdering", sort);
                if (this.getTreeViewer() != null) {
                    this.getTreeViewer().refresh();
                }
            }
        }

        private boolean allowSettersForFinals() {
            return this.fAllowSettersForFinals;
        }

        public void allowSettersForFinals(boolean allowSettersForFinals) {
            if (this.fAllowSettersForFinals != allowSettersForFinals) {
                this.fAllowSettersForFinals = allowSettersForFinals;
                this.fSettings.put("RemoveFinal", allowSettersForFinals);
                CheckboxTreeViewer treeViewer = this.getTreeViewer();
                if (treeViewer != null) {
                    ArrayList<GetterSetterEntry> newChecked = new ArrayList<GetterSetterEntry>();
                    if (allowSettersForFinals) {
                        newChecked.addAll(this.fPreviousSelectedFinals);
                    }
                    this.fPreviousSelectedFinals.clear();
                    Object[] checkedElements = treeViewer.getCheckedElements();
                    int i = 0;
                    while (i < checkedElements.length) {
                        if (checkedElements[i] instanceof GetterSetterEntry) {
                            GetterSetterEntry entry = (GetterSetterEntry)checkedElements[i];
                            if (allowSettersForFinals || entry.isGetter || !entry.isFinal) {
                                newChecked.add(entry);
                            } else {
                                this.fPreviousSelectedFinals.add(entry);
                            }
                        }
                        ++i;
                    }
                    if (allowSettersForFinals) {
                        treeViewer.removeFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
                    } else {
                        treeViewer.addFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
                    }
                    treeViewer.setCheckedElements(newChecked.toArray());
                }
                this.updateOKStatus();
            }
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
            if (!this.fAllowSettersForFinals) {
                treeViewer.addFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
            }
            return treeViewer;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.add_getter_setter_selection_dialog_context");
        }

        private void createGetterSetterButtons(Composite buttonComposite) {
            this.createButton(buttonComposite, 1025, ActionMessages.GetterSetterTreeSelectionDialog_select_getters, false);
            this.createButton(buttonComposite, 1026, ActionMessages.GetterSetterTreeSelectionDialog_select_setters, false);
        }

        @Override
        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            switch (buttonId) {
                case 1025: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(true));
                    this.updateOKStatus();
                    break;
                }
                case 1026: {
                    this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(false));
                    this.updateOKStatus();
                }
            }
        }

        @Override
        protected Composite createInsertPositionCombo(Composite composite) {
            Button addRemoveFinalCheckbox = this.addAllowSettersForFinalslCheckbox(composite);
            addRemoveFinalCheckbox.setLayoutData((Object)new GridData(768));
            Composite entryComposite = super.createInsertPositionCombo(composite);
            this.addSortOrder(entryComposite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        private Button addAllowSettersForFinalslCheckbox(Composite entryComposite) {
            Button allowSettersForFinalsButton = new Button(entryComposite, 32);
            allowSettersForFinalsButton.setText(ActionMessages.AddGetterSetterAction_allow_setters_for_finals_description);
            allowSettersForFinalsButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.allowSettersForFinals(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            allowSettersForFinalsButton.setSelection(this.allowSettersForFinals());
            return allowSettersForFinalsButton;
        }

        private Composite addSortOrder(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(ActionMessages.GetterSetterTreeSelectionDialog_sort_label);
            GridData gd = new GridData(1808);
            label.setLayoutData((Object)gd);
            final Combo combo = new Combo(composite, 8);
            combo.setItems(new String[]{ActionMessages.GetterSetterTreeSelectionDialog_alpha_pair_sort, ActionMessages.GetterSetterTreeSelectionDialog_alpha_method_sort});
            int sort = this.getSortOrder() ? 1 : 0;
            combo.setText(combo.getItem(sort));
            gd = new GridData(1808);
            combo.setLayoutData((Object)gd);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.setSortOrder(combo.getSelectionIndex() == 1);
                }
            });
            return composite;
        }

        private Object[] getGetterSetterElements(boolean isGetter) {
            Object[] allFields = this.fContentProvider.getElements(null);
            HashSet<GetterSetterEntry> result = new HashSet<GetterSetterEntry>();
            int i = 0;
            while (i < allFields.length) {
                IField field = (IField)allFields[i];
                GetterSetterEntry[] entries = this.getEntries(field);
                int j = 0;
                while (j < entries.length) {
                    GetterSetterEntry entry = entries[j];
                    if (entry.isGetter == isGetter) {
                        result.add(entry);
                    }
                    ++j;
                }
                ++i;
            }
            return result.toArray();
        }

        private GetterSetterEntry[] getEntries(IField field) {
            List<Object> result = Arrays.asList(this.fContentProvider.getChildren(field));
            return result.toArray(new GetterSetterEntry[result.size()]);
        }

        @Override
        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = super.createSelectionButtons(composite);
            GridLayout layout = new GridLayout();
            buttonComposite.setLayout((Layout)layout);
            this.createGetterSetterButtons(buttonComposite);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            return buttonComposite;
        }

        @Override
        protected Control createLinkControl(Composite composite) {
            Link link = new Link(composite, 64);
            link.setText(ActionMessages.AddGetterSetterAction_template_link_description);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.openCodeTempatePage("org.eclipse.jdt.ui.text.codetemplates.gettercomment");
                }
            });
            link.setToolTipText(ActionMessages.AddGetterSetterAction_template_link_tooltip);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(40);
            link.setLayoutData((Object)gridData);
            return link;
        }
    }

    private static class SettersForFinalFieldsFilter
    extends ViewerFilter {
        private final AddGetterSetterContentProvider fContentProvider;

        public SettersForFinalFieldsFilter(AddGetterSetterContentProvider contentProvider) {
            this.fContentProvider = contentProvider;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry getterSetterEntry = (GetterSetterEntry)element;
                return getterSetterEntry.isGetter || !getterSetterEntry.isFinal;
            }
            if (element instanceof IField) {
                Object[] children = this.fContentProvider.getChildren(element);
                int i = 0;
                while (i < children.length) {
                    GetterSetterEntry curr = (GetterSetterEntry)children[i];
                    if (curr.isGetter || !curr.isFinal) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
    }
}

