/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;

public class NodePhysicalComponentExchangesCreator
extends DefaultExchangesCreator {
    private Part part = null;

    public NodePhysicalComponentExchangesCreator(Component component, Part part) {
        super(component);
        if (part != null) {
            this.part = part;
        }
    }

    @Override
    public void createExchanges() {
        if (this._component instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent node = (AbstractPhysicalComponent)this._component;
            this.createExchangesForDeployedPhysicalComponents(node);
            super.createExchanges();
        }
    }

    @Override
    protected boolean isValidBound(Component component) {
        if (component instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent cpnt = (AbstractPhysicalComponent)component;
            PhysicalComponentNature nature = cpnt.getNature();
            if (cpnt instanceof PhysicalComponent && nature == PhysicalComponentNature.NODE) {
                return true;
            }
            if (cpnt instanceof PhysicalActor) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidCreation(AbstractEventOperation fe, Component component, Component allocating) {
        return this.isValidBound(component) && this.isValidBound(allocating);
    }

    protected void createExchangesForDeployedPhysicalComponents(AbstractPhysicalComponent node) {
        EList deployments = this.part.getDeploymentLinks();
        for (AbstractDeploymentLink deployment : deployments) {
            if (!(deployment instanceof PartDeploymentLink)) continue;
            PartDeploymentLink deploymentLink = (PartDeploymentLink)deployment;
            DeployableElement deployedElement = deploymentLink.getDeployedElement();
            if (deployedElement != null && deployedElement instanceof Part) {
                Part part = (Part)deployedElement;
                Type type = part.getType();
                if (type == null) continue;
                this.createExchangesFromDeployedElement(node, type);
                continue;
            }
            if (deployedElement == null || !(deployedElement instanceof AbstractPhysicalComponent)) continue;
            this.createExchangesFromDeployedElement(node, (Type)((AbstractPhysicalComponent)deployedElement));
        }
    }

    private void createExchangesFromDeployedElement(AbstractPhysicalComponent node, Type type) {
        if (type != null && type instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent deployedPhysicalComponent = (AbstractPhysicalComponent)type;
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)deployedPhysicalComponent)) {
                for (ComponentExchange connection : port.getComponentExchanges()) {
                    EObject container;
                    InformationsExchanger target;
                    if (connection.getKind() == ComponentExchangeKind.DELEGATION || connection.getKind() == ComponentExchangeKind.UNSET || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(node, connection) || (target = FunctionalExt.getOtherBound((ExchangeSpecification)connection, (InformationsExchanger)port)) == null || !(target instanceof ComponentPort) || !((container = target.eContainer()) instanceof AbstractPhysicalComponent)) continue;
                    for (Partition partition : ((AbstractPhysicalComponent)container).getRepresentingPartitions()) {
                        if (!(partition instanceof Part)) continue;
                        for (DeploymentTarget deploying : PartExt.getDeployingElements((Part)((Part)partition))) {
                            AbstractPhysicalComponent typeDeploying;
                            Part deployingPart;
                            if (!(deploying instanceof Part) || (deployingPart = (Part)deploying).getAbstractType() == null || !(deployingPart.getAbstractType() instanceof AbstractPhysicalComponent) || !this.isValidCreation((AbstractEventOperation)connection, (Component)node, (Component)(typeDeploying = (AbstractPhysicalComponent)deployingPart.getAbstractType())) || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(node, connection)) continue;
                            if (connection.getSource().equals(port)) {
                                this.doCreateExchange(connection, (Component)node, (Component)typeDeploying);
                                continue;
                            }
                            this.doCreateExchange(connection, (Component)typeDeploying, (Component)node);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doCreateExchange(FunctionalExchange functionalExchange, Component exchangeOutput, Component exchangeInput) {
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(functionalExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange.getSource().getName());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange.getTarget().getName());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        PortExt.attachPort((Port)outP, (ActivityNode)functionalExchange.getSource());
        PortExt.attachPort((Port)inP, (ActivityNode)functionalExchange.getTarget());
    }

    protected void doCreateExchange(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput) {
        if (exchangeOutput == exchangeInput) {
            return;
        }
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(componentExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getSource().getLabel());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getTarget().getLabel());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        CapellaElementExt.creationService((EObject)inP);
        CapellaElementExt.creationService((EObject)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        CapellaElementExt.creationService((EObject)physicalLink);
        ComponentExchangeAllocation cea = FaFactory.eINSTANCE.createComponentExchangeAllocation();
        cea.setSourceElement((TraceableElement)physicalLink);
        cea.setTargetElement((TraceableElement)componentExchange);
        physicalLink.getOwnedComponentExchangeAllocations().add((Object)cea);
        CapellaElementExt.creationService((EObject)cea);
        InformationsExchanger target = componentExchange.getTarget();
        this.createComponentPortAllocation(target, inP);
        InformationsExchanger source = componentExchange.getSource();
        this.createComponentPortAllocation(source, outP);
    }

    private ComponentPortAllocation createComponentPortAllocation(InformationsExchanger informationExchange, PhysicalPort physicalPort) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)physicalPort);
        allocation.setTargetElement((TraceableElement)informationExchange);
        physicalPort.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
        return allocation;
    }

    protected boolean doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(AbstractPhysicalComponent physicalComponent, ComponentExchange componentExchange) {
        boolean result = false;
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)componentExchange);
        SemanticCrossReferencer crossReferencer = editingDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences((EObject)componentExchange, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof ComponentExchangeAllocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

