/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.CloneDiagramCommand;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CloneAction
extends BaseSelectionListenerAction {
    private Collection<DRepresentationDescriptor> _representationDescriptors;
    protected TreeViewer _viewer;

    public CloneAction(TreeViewer viewer_p) {
        super(Messages.CloneAction_0);
        this._viewer = viewer_p;
    }

    protected Collection<DRepresentationDescriptor> getSelectedRepresentations(List<?> selectedElements_p) {
        List<DRepresentationDescriptor> result = null;
        for (Object element : selectedElements_p) {
            if (!(element instanceof DRepresentationDescriptor)) continue;
            if (result == null) {
                result = new ArrayList<DRepresentationDescriptor>(1);
            }
            result.add((DRepresentationDescriptor)element);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public void run() {
        CloneDiagramCommand command = new CloneDiagramCommand(this._representationDescriptors);
        command.addCloneListener(new CloneDiagramCommand.ICloneListener(){

            @Override
            public void cloneAboutToBeRemoved(final DRepresentation clone_p, Session session_p) {
                if (CloneAction.this._viewer != null) {
                    Runnable removeRunnable = new Runnable(){

                        @Override
                        public void run() {
                            (this).CloneAction.this._viewer.remove((Object)clone_p);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(removeRunnable);
                    } else {
                        removeRunnable.run();
                    }
                }
            }

            @Override
            public void cloneCreated(final DRepresentation clone_p, final Session session_p) {
                if (CloneAction.this._viewer != null) {
                    Runnable addRunnable = new Runnable(){

                        @Override
                        public void run() {
                            EObject parent = ((DSemanticDecorator)clone_p).getTarget();
                            (this).CloneAction.this._viewer.add((Object)parent, (Object)clone_p);
                            SessionManager.INSTANCE.notifyRepresentationCreated(session_p);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(addRunnable);
                    } else {
                        addRunnable.run();
                    }
                }
            }
        });
        TransactionUtil.getEditingDomain((EObject)((EObject)this._representationDescriptors.iterator().next())).getCommandStack().execute((Command)command);
    }

    protected boolean updateSelection(IStructuredSelection selection_p) {
        List selectedElements = selection_p.toList();
        this._representationDescriptors = this.getSelectedRepresentations(selectedElements);
        int size = selectedElements.size();
        return size > 0 && size == this._representationDescriptors.size();
    }
}

