/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.List;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.SplitFeedbackOverlay;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SplitDropAgent2
extends DropAgent {
    private static final int TOLERANCE = 35;
    private MUIElement relToElement = null;
    private SplitFeedbackOverlay feedback = null;
    private int dragElementLocation;
    private int where;
    private float ratio = 0.5f;
    private Rectangle trackRect;
    private boolean wasModified = false;

    public SplitDropAgent2(DnDManager manager) {
        super(manager);
    }

    @Override
    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        this.relToElement = this.getTargetElement(dragElement, info);
        return this.relToElement != null;
    }

    private MUIElement getTargetElement(MUIElement dragElement, DnDInfo info) {
        MUIElement target = null;
        this.dragElementLocation = this.dndManager.getModelService().getElementLocation(dragElement);
        if (this.dragElementLocation == 8 || this.dragElementLocation == 2) {
            target = this.checkAreaEdge(dragElement, info);
        }
        if (target == null && this.dragElementLocation == 2 || this.dragElementLocation == 1) {
            target = this.checkPerspectiveEdge(dragElement, info);
        }
        if (target == null) {
            target = this.checkStacks(dragElement, info);
        }
        return target;
    }

    private boolean isInCursorShell(DnDInfo info, Control ctrl) {
        if (ctrl == null || info.curCtrl == null || info.curCtrl.isDisposed()) {
            return false;
        }
        Shell infoShell = (Shell)(info.curCtrl instanceof Shell ? info.curCtrl : info.curCtrl.getShell());
        return ctrl.getShell() == infoShell;
    }

    private MPartStack checkStacks(final MUIElement dragElement, final DnDInfo info) {
        MPartStack candidateStack = null;
        final EModelService ms = this.dndManager.getModelService();
        List stacks = ms.findElements((MApplicationElement)ms.getTopLevelWindowFor(dragElement), MPartStack.class, 11, new Selector(){

            public boolean select(MApplicationElement element) {
                MPartStack stack = (MPartStack)element;
                if (!stack.isVisible() || !(stack.getWidget() instanceof CTabFolder)) {
                    return false;
                }
                CTabFolder ctf = (CTabFolder)stack.getWidget();
                if (ctf.isDisposed()) {
                    return false;
                }
                if (!SplitDropAgent2.this.isInCursorShell(info, (Control)ctf)) {
                    return false;
                }
                Rectangle bb = ctf.getClientArea();
                bb = ctf.getDisplay().map((Control)ctf, null, bb);
                if (!bb.contains(info.cursorPos)) {
                    return false;
                }
                if (dragElement instanceof MPartStack && stack == dragElement) {
                    return false;
                }
                MElementContainer deParent = dragElement.getParent();
                return !(dragElement instanceof MStackElement) || stack != deParent || ms.countRenderableChildren((MUIElement)deParent) != 1;
            }
        });
        if (stacks.size() > 0 && (candidateStack = (MPartStack)stacks.get(0)).getWidget() instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)candidateStack.getWidget();
            this.trackRect = ctf.getClientArea();
            this.trackRect = ctf.getDisplay().map((Control)ctf, null, this.trackRect);
        }
        return candidateStack;
    }

    private MUIElement checkAreaEdge(MUIElement dragElement, DnDInfo info) {
        MArea area;
        Control ctrl;
        MPerspective persp = this.dndManager.getModelService().getPerspectiveFor(dragElement);
        List areaList = this.dndManager.getModelService().findElements((MUIElement)persp, null, MArea.class, null, 8);
        if (areaList.size() > 0 && this.checkEdge(info, ctrl = (Control)(area = (MArea)areaList.get(0)).getWidget())) {
            return area;
        }
        return null;
    }

    private MUIElement checkPerspectiveEdge(MUIElement dragElement, DnDInfo info) {
        Control ctrl;
        MWindow win = this.dndManager.getModelService().getTopLevelWindowFor(dragElement);
        MPerspective persp = this.dndManager.getModelService().getActivePerspective(win);
        if (persp != null && persp.getWidget() instanceof Control && this.checkEdge(info, ctrl = (Control)persp.getWidget())) {
            return persp;
        }
        return null;
    }

    private boolean checkEdge(DnDInfo info, Control ctrl) {
        boolean onEdge = false;
        if (!this.isInCursorShell(info, ctrl)) {
            return false;
        }
        Rectangle bb = ctrl.getBounds();
        bb = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bb);
        if (bb.contains(info.cursorPos)) {
            Point p = info.cursorPos;
            if (p.x - bb.x < 35) {
                this.where = 2;
                this.trackRect = new Rectangle(bb.x, bb.y, 35, bb.height);
                onEdge = true;
            } else if (bb.x + bb.width - p.x < 35) {
                this.where = 3;
                this.trackRect = new Rectangle(bb.x + (bb.width - 35), bb.y, 35, bb.height);
                onEdge = true;
            } else if (bb.y + bb.height - p.y < 35) {
                this.where = 1;
                this.trackRect = new Rectangle(bb.x, bb.y + (bb.height - 35), bb.width, 35);
                onEdge = true;
            }
        }
        return onEdge;
    }

    @Override
    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        super.dragEnter(dragElement, info);
        this.where = this.setRelToInfo(info);
        this.showFeedback();
    }

    private int setRelToInfo(DnDInfo info) {
        if (this.relToElement instanceof MPerspective || this.relToElement instanceof MArea) {
            this.ratio = 0.33f;
            return this.where;
        }
        if (this.relToElement instanceof MPartStack) {
            this.ratio = 0.5f;
            Point p = info.cursorPos;
            int dTop = p.y - this.trackRect.y;
            int dBottom = this.trackRect.y + this.trackRect.height - p.y;
            int dLeft = p.x - this.trackRect.x;
            int dRight = this.trackRect.x + this.trackRect.width - p.x;
            if (this.trackRect.width >= this.trackRect.height) {
                int thirdOfWidth = this.trackRect.width / 3;
                if (dLeft < thirdOfWidth) {
                    return 2;
                }
                if (dRight < thirdOfWidth) {
                    return 3;
                }
                return dTop < dBottom ? 0 : 1;
            }
            int thirdOfHeight = this.trackRect.height / 3;
            if (dTop < thirdOfHeight) {
                return 0;
            }
            if (dBottom < thirdOfHeight) {
                return 1;
            }
            if (this.relToElement != null) {
                return dLeft < dRight ? 2 : 3;
            }
        }
        return -1;
    }

    @Override
    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        this.dndManager.clearOverlay();
        this.clearFeedback();
        this.relToElement = null;
        this.reactivatePart(dragElement);
        super.dragLeave(dragElement, info);
    }

    @Override
    public boolean drop(MUIElement dragElement, DnDInfo info) {
        MPartSashContainerElement toInsert = (MPartSashContainerElement)dragElement;
        if (dragElement instanceof MPartStack) {
            if (toInsert.getTags().contains("Minimized")) {
                toInsert.getTags().remove("Minimized");
            }
            toInsert.getParent().getChildren().remove(toInsert);
        } else {
            MStackElement stackElement = (MStackElement)dragElement;
            MPartStack newStack = BasicFactoryImpl.eINSTANCE.createPartStack();
            newStack.getChildren().add(stackElement);
            newStack.setSelectedElement((MUIElement)stackElement);
            toInsert = newStack;
        }
        if (this.dndManager.getModelService().isLastEditorStack(this.relToElement)) {
            MElementContainer targetParent = this.relToElement.getParent();
            while (!(targetParent instanceof MArea)) {
                targetParent = targetParent.getParent();
            }
            this.relToElement = targetParent;
        }
        if (this.relToElement instanceof MArea) {
            boolean shouldBePlacedInSharedArea;
            boolean fromSharedArea = this.dragElementLocation == 8;
            boolean bl = shouldBePlacedInSharedArea = fromSharedArea == !this.isModified();
            if (shouldBePlacedInSharedArea) {
                MArea area = (MArea)this.relToElement;
                this.relToElement = (MUIElement)area.getChildren().get(0);
            }
        } else if (this.relToElement instanceof MPerspective && this.dragElementLocation == 2) {
            MPerspective persp = (MPerspective)this.relToElement;
            this.relToElement = (MUIElement)persp.getChildren().get(0);
        }
        this.dndManager.getModelService().insert(toInsert, (MPartSashContainerElement)this.relToElement, this.where, this.ratio);
        return true;
    }

    private boolean isModified() {
        return this.dndManager.isModified && (this.relToElement instanceof MArea || this.relToElement instanceof MPerspective || this.dndManager.getModelService().isLastEditorStack(this.relToElement));
    }

    @Override
    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (this.getTargetElement(dragElement, info) != this.relToElement) {
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
            return false;
        }
        if (!this.trackRect.contains(info.cursorPos)) {
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
            return false;
        }
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
        int curWhere = this.where;
        this.where = this.setRelToInfo(info);
        if (this.where == curWhere && this.wasModified == this.isModified()) {
            return true;
        }
        this.wasModified = this.isModified();
        this.showFeedback();
        return true;
    }

    private void showFeedback() {
        if (this.relToElement == null || !(this.relToElement.getWidget() instanceof Control)) {
            return;
        }
        int side = -1;
        if (this.where == 0) {
            side = 128;
        } else if (this.where == 1) {
            side = 1024;
        } else if (this.where == 2) {
            side = 16384;
        } else if (this.where == 3) {
            side = 131072;
        }
        if (this.feedback != null) {
            this.feedback.dispose();
        }
        Control ctrl = (Control)this.relToElement.getWidget();
        Rectangle bb = ctrl.getBounds();
        bb = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bb);
        this.feedback = new SplitFeedbackOverlay(ctrl.getShell(), bb, side, this.ratio, this.isModified(), this.isModified());
        this.feedback.setVisible(true);
    }

    private void clearFeedback() {
        if (this.feedback == null) {
            return;
        }
        this.feedback.dispose();
        this.feedback = null;
    }
}

