/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.part;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSContext;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.oa.OperationalContext;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_ComponentContextPartitions
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentContext) {
            ComponentContext ccontext = (ComponentContext)eObj;
            EList ownedPartitions = ccontext.getOwnedPartitions();
            Iterator iterator = ownedPartitions.iterator();
            if (ccontext instanceof OperationalContext) {
                return ctx.createSuccessStatus();
            }
            if (ccontext instanceof SystemContext) {
                while (iterator.hasNext()) {
                    Partition part = (Partition)iterator.next();
                    if (!(part.getAbstractType() instanceof System)) continue;
                    return ctx.createSuccessStatus();
                }
            } else if (ccontext instanceof LogicalContext) {
                while (iterator.hasNext()) {
                    Partition part = (Partition)iterator.next();
                    if (!(part.getAbstractType() instanceof LogicalComponent)) continue;
                    return ctx.createSuccessStatus();
                }
            } else if (ccontext instanceof PhysicalContext) {
                while (iterator.hasNext()) {
                    Partition part = (Partition)iterator.next();
                    if (!(part.getAbstractType() instanceof PhysicalComponent)) continue;
                    return ctx.createSuccessStatus();
                }
            } else if (ccontext instanceof EPBSContext) {
                while (iterator.hasNext()) {
                    Partition part = (Partition)iterator.next();
                    if (!(part.getAbstractType() instanceof ConfigurationItem)) continue;
                    return ctx.createSuccessStatus();
                }
            }
            return this.createFailureStatus(ctx, new Object[]{ccontext.getName(), ccontext.eClass().getName()});
        }
        return ctx.createSuccessStatus();
    }
}

