/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.traceability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerFactory;
import org.polarsys.capella.core.data.capellamodeller.Folder;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.handler.command.DeleteStructureCommand;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyChangeEvent;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyListener;
import org.polarsys.capella.core.transition.common.handlers.notify.NotifyHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityTraceHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LinkTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class RealizationLinkTraceabilityHandler
extends LinkTraceabilityHandler
implements ITraceabilityTraceHandler,
INotifyListener {
    public static final String MAPPING_MAP = "_mPp";
    public static final String REALISATION_LINKS = "_rL";
    public static final String REALISATION_LINKS_UNATTACHED = "_rLu";
    public static final String DEFAULT_OWNER = "DEFAULT_OWNER";
    private RealizationLinkMapping defaultMapping = new RealizationLinkMapping(this, ModellingcorePackage.Literals.TRACEABLE_ELEMENT, ModellingcorePackage.Literals.TRACEABLE_ELEMENT, CapellacommonPackage.Literals.TRANSFO_LINK, (EStructuralFeature)CapellacorePackage.Literals.NAMESPACE__OWNED_TRACES){

        @Override
        public boolean isValid(EObject sourceElement, EObject targetElement, IContext context) {
            if (sourceElement instanceof BlockArchitecture && targetElement instanceof BlockArchitecture) {
                return false;
            }
            if (sourceElement instanceof ComponentExchange && targetElement instanceof Interface) {
                return false;
            }
            return super.isValid(sourceElement, targetElement, context);
        }

        @Override
        public boolean isValidSource(EObject targetElement, IContext context) {
            return this.source.isInstance((Object)targetElement);
        }

        @Override
        public boolean isValidTarget(EObject targetElement, IContext context) {
            return this.target.isInstance((Object)targetElement);
        }
    };
    private String _realizationIdentifier = "_rL" + this.getIdentifier();

    public RealizationLinkMapping getDefaultMapping() {
        return this.defaultMapping;
    }

    public RealizationLinkTraceabilityHandler(String identifier) {
        super(identifier);
    }

    public IStatus init(IContext context) {
        NotifyHandlerHelper.getInstance((IContext)context).addListener("NOTIFY__END_TRANSFORMATION", (INotifyListener)this, context);
        return super.init(context);
    }

    public IStatus dispose(IContext context) {
        this.disposeUnattachedElements(context);
        return super.dispose(context);
    }

    private void disposeUnattachedElements(IContext context) {
        DeleteStructureCommand command;
        List<Namespace> traces = Collections.singletonList(this.getDefaultOwner(context));
        if (!traces.isEmpty() && (command = new DeleteStructureCommand((EditingDomain)((TransactionalEditingDomain)context.get((Object)"TRANSITION_TARGET_EDITING_DOMAIN")), (Collection)this.getDefaultOwner(context).eContents())).canExecute()) {
            command.execute();
        }
    }

    protected Namespace getDefaultOwner(IContext context) {
        if (!context.exists((Object)DEFAULT_OWNER)) {
            Folder owner = CapellamodellerFactory.eINSTANCE.createFolder();
            AttachmentHelper.getInstance((IContext)context).createdElement((EObject)owner, (EObject)owner, context);
            context.put((Object)DEFAULT_OWNER, (Object)owner);
        }
        return (Namespace)context.get((Object)DEFAULT_OWNER);
    }

    protected Collection<AbstractTrace> getRealizationLinks(IContext context) {
        if (!context.exists((Object)this._realizationIdentifier)) {
            ArrayList mapping = new ArrayList();
            context.put((Object)this._realizationIdentifier, mapping);
        }
        return (Collection)context.get((Object)this._realizationIdentifier);
    }

    protected Collection<RealizationLinkMapping> getMappings(IContext iContext1) {
        if (!iContext1.exists((Object)MAPPING_MAP)) {
            ArrayList<RealizationLinkMapping> mapping = new ArrayList<RealizationLinkMapping>();
            iContext1.put((Object)MAPPING_MAP, mapping);
            this.mappingAdd(mapping, new RealizationLinkMapping(this, CsPackage.Literals.INTERFACE, CsPackage.Literals.INTERFACE, PaPackage.Literals.LOGICAL_INTERFACE_REALIZATION, (EStructuralFeature)CsPackage.Literals.INTERFACE_ALLOCATOR__OWNED_INTERFACE_ALLOCATIONS){

                @Override
                public boolean isValid(EObject sourceElement, EObject targetElement, IContext context) {
                    return !CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)sourceElement));
                }
            });
            this.mappingAdd(mapping, new RealizationLinkMapping(this, CsPackage.Literals.INTERFACE, CsPackage.Literals.INTERFACE, LaPackage.Literals.CONTEXT_INTERFACE_REALIZATION, (EStructuralFeature)CsPackage.Literals.INTERFACE_ALLOCATOR__OWNED_INTERFACE_ALLOCATIONS){

                @Override
                public boolean isValid(EObject sourceElement, EObject targetElement, IContext context) {
                    return CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)sourceElement));
                }
            });
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_REALIZATION, (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CsPackage.Literals.PHYSICAL_LINK, CsPackage.Literals.PHYSICAL_LINK, CsPackage.Literals.PHYSICAL_LINK_REALIZATION, (EStructuralFeature)CsPackage.Literals.PHYSICAL_LINK__OWNED_PHYSICAL_LINK_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CsPackage.Literals.PHYSICAL_PATH, CsPackage.Literals.PHYSICAL_PATH, CsPackage.Literals.PHYSICAL_PATH_REALIZATION, (EStructuralFeature)CsPackage.Literals.PHYSICAL_PATH__OWNED_PHYSICAL_PATH_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.COMMUNICATION_MEAN, FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_REALIZATION, (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE_REALIZATION, (EStructuralFeature)FaPackage.Literals.FUNCTIONAL_EXCHANGE__OWNED_FUNCTIONAL_EXCHANGE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.COMPONENT_EXCHANGE, FaPackage.Literals.FUNCTIONAL_EXCHANGE, FaPackage.Literals.COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATION, (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(InformationPackage.Literals.PORT, InformationPackage.Literals.PORT, InformationPackage.Literals.PORT_REALIZATION, (EStructuralFeature)InformationPackage.Literals.PORT__OWNED_PORT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.COMPONENT_PORT, FaPackage.Literals.COMPONENT_PORT, InformationPackage.Literals.PORT_REALIZATION, (EStructuralFeature)InformationPackage.Literals.PORT__OWNED_PORT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO_REALIZATION, (EStructuralFeature)InteractionPackage.Literals.SCENARIO__OWNED_SCENARIO_REALIZATION));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.OPERATIONAL_CAPABILITY, CtxPackage.Literals.CAPABILITY, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION, (EStructuralFeature)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_ABSTRACT_CAPABILITY_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CtxPackage.Literals.CAPABILITY, LaPackage.Literals.CAPABILITY_REALIZATION, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION, (EStructuralFeature)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_ABSTRACT_CAPABILITY_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(LaPackage.Literals.CAPABILITY_REALIZATION, LaPackage.Literals.CAPABILITY_REALIZATION, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION, (EStructuralFeature)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_ABSTRACT_CAPABILITY_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.CHOICE_PSEUDO_STATE, CapellacommonPackage.Literals.CHOICE_PSEUDO_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.FORK_PSEUDO_STATE, CapellacommonPackage.Literals.FORK_PSEUDO_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.INITIAL_PSEUDO_STATE, CapellacommonPackage.Literals.INITIAL_PSEUDO_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.JOIN_PSEUDO_STATE, CapellacommonPackage.Literals.JOIN_PSEUDO_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.TERMINATE_PSEUDO_STATE, CapellacommonPackage.Literals.TERMINATE_PSEUDO_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.FINAL_STATE, CapellacommonPackage.Literals.FINAL_STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.MODE, CapellacommonPackage.Literals.MODE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.STATE, CapellacommonPackage.Literals.STATE, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.ABSTRACT_STATE__OWNED_ABSTRACT_STATE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.STATE_TRANSITION, CapellacommonPackage.Literals.STATE_TRANSITION, CapellacommonPackage.Literals.STATE_TRANSITION_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.STATE_TRANSITION__OWNED_STATE_TRANSITION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.CHANGE_EVENT, CapellacommonPackage.Literals.CHANGE_EVENT, CapellacommonPackage.Literals.STATE_EVENT_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.STATE_EVENT__OWNED_STATE_EVENT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CapellacommonPackage.Literals.TIME_EVENT, CapellacommonPackage.Literals.TIME_EVENT, CapellacommonPackage.Literals.STATE_EVENT_REALIZATION, (EStructuralFeature)CapellacommonPackage.Literals.STATE_EVENT__OWNED_STATE_EVENT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.OPERATIONAL_PROCESS, FaPackage.Literals.FUNCTIONAL_CHAIN, FaPackage.Literals.FUNCTIONAL_CHAIN_REALIZATION, (EStructuralFeature)FaPackage.Literals.FUNCTIONAL_CHAIN__OWNED_FUNCTIONAL_CHAIN_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.FUNCTIONAL_CHAIN, FaPackage.Literals.FUNCTIONAL_CHAIN, FaPackage.Literals.FUNCTIONAL_CHAIN_REALIZATION, (EStructuralFeature)FaPackage.Literals.FUNCTIONAL_CHAIN__OWNED_FUNCTIONAL_CHAIN_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(DatatypePackage.Literals.BOOLEAN_TYPE, DatatypePackage.Literals.BOOLEAN_TYPE, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)DatatypePackage.Literals.DATA_TYPE__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(DatatypePackage.Literals.ENUMERATION, DatatypePackage.Literals.ENUMERATION, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)DatatypePackage.Literals.DATA_TYPE__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(DatatypePackage.Literals.NUMERIC_TYPE, DatatypePackage.Literals.NUMERIC_TYPE, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)DatatypePackage.Literals.DATA_TYPE__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(DatatypePackage.Literals.PHYSICAL_QUANTITY, DatatypePackage.Literals.PHYSICAL_QUANTITY, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)DatatypePackage.Literals.DATA_TYPE__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(DatatypePackage.Literals.STRING_TYPE, DatatypePackage.Literals.STRING_TYPE, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)DatatypePackage.Literals.DATA_TYPE__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(InformationPackage.Literals.CLASS, InformationPackage.Literals.CLASS, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)InformationPackage.Literals.CLASS__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(InformationPackage.Literals.EXCHANGE_ITEM, InformationPackage.Literals.EXCHANGE_ITEM, InformationPackage.Literals.INFORMATION_REALIZATION, (EStructuralFeature)InformationPackage.Literals.EXCHANGE_ITEM__OWNED_INFORMATION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.OPERATIONAL_ACTIVITY, CtxPackage.Literals.SYSTEM_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CtxPackage.Literals.SYSTEM_FUNCTION, LaPackage.Literals.LOGICAL_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(LaPackage.Literals.LOGICAL_FUNCTION, PaPackage.Literals.PHYSICAL_FUNCTION, FaPackage.Literals.FUNCTION_REALIZATION, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.FUNCTION_INPUT_PORT, FaPackage.Literals.FUNCTION_INPUT_PORT, InformationPackage.Literals.PORT_REALIZATION, (EStructuralFeature)InformationPackage.Literals.PORT__OWNED_PORT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(FaPackage.Literals.FUNCTION_OUTPUT_PORT, FaPackage.Literals.FUNCTION_OUTPUT_PORT, InformationPackage.Literals.PORT_REALIZATION, (EStructuralFeature)InformationPackage.Literals.PORT__OWNED_PORT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.OPERATIONAL_ACTOR, CtxPackage.Literals.ACTOR, CtxPackage.Literals.OPERATIONAL_ACTOR_REALIZATION, (EStructuralFeature)CtxPackage.Literals.ACTOR__OWNED_OPERATIONAL_ACTOR_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.ENTITY, CtxPackage.Literals.ACTOR, CtxPackage.Literals.OPERATIONAL_ENTITY_REALIZATION, (EStructuralFeature)CtxPackage.Literals.ACTOR__OWNED_OPERATIONAL_ENTITY_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CtxPackage.Literals.ACTOR, LaPackage.Literals.LOGICAL_ACTOR, LaPackage.Literals.SYSTEM_ACTOR_REALIZATION, (EStructuralFeature)LaPackage.Literals.LOGICAL_ACTOR__OWNED_SYSTEM_ACTOR_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(LaPackage.Literals.LOGICAL_ACTOR, PaPackage.Literals.PHYSICAL_ACTOR, PaPackage.Literals.LOGICAL_ACTOR_REALIZATION, (EStructuralFeature)PaPackage.Literals.PHYSICAL_ACTOR__OWNED_LOGICAL_ACTOR_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.ENTITY, CtxPackage.Literals.SYSTEM, CtxPackage.Literals.OPERATIONAL_ENTITY_REALIZATION, (EStructuralFeature)CtxPackage.Literals.SYSTEM__OWNED_ENTITY_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CtxPackage.Literals.SYSTEM, LaPackage.Literals.LOGICAL_COMPONENT, LaPackage.Literals.SYSTEM_REALIZATION, (EStructuralFeature)LaPackage.Literals.LOGICAL_COMPONENT__OWNED_SYSTEM_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(LaPackage.Literals.LOGICAL_COMPONENT, PaPackage.Literals.PHYSICAL_COMPONENT, PaPackage.Literals.LOGICAL_COMPONENT_REALIZATION, (EStructuralFeature)PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_LOGICAL_COMPONENT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(OaPackage.Literals.OPERATIONAL_ANALYSIS, CtxPackage.Literals.SYSTEM_ANALYSIS, CtxPackage.Literals.OPERATIONAL_ANALYSIS_REALIZATION, (EStructuralFeature)CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_OPERATIONAL_ANALYSIS_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CtxPackage.Literals.SYSTEM_ANALYSIS, LaPackage.Literals.LOGICAL_ARCHITECTURE, LaPackage.Literals.SYSTEM_ANALYSIS_REALIZATION, (EStructuralFeature)LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_SYSTEM_ANALYSIS_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(LaPackage.Literals.LOGICAL_ARCHITECTURE, PaPackage.Literals.PHYSICAL_ARCHITECTURE, PaPackage.Literals.LOGICAL_ARCHITECTURE_REALIZATION, (EStructuralFeature)PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_LOGICAL_ARCHITECTURE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(PaPackage.Literals.PHYSICAL_ARCHITECTURE, EpbsPackage.Literals.EPBS_ARCHITECTURE, EpbsPackage.Literals.PHYSICAL_ARCHITECTURE_REALIZATION, (EStructuralFeature)EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_PHYSICAL_ARCHITECTURE_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CsPackage.Literals.PHYSICAL_PORT, CsPackage.Literals.PHYSICAL_PORT, CsPackage.Literals.PHYSICAL_PORT_REALIZATION, (EStructuralFeature)CsPackage.Literals.PHYSICAL_PORT__OWNED_PHYSICAL_PORT_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CsPackage.Literals.PHYSICAL_PORT, CsPackage.Literals.PHYSICAL_LINK, CsPackage.Literals.PHYSICAL_LINK_REALIZATION, (EStructuralFeature)CsPackage.Literals.PHYSICAL_LINK__OWNED_PHYSICAL_LINK_REALIZATIONS));
            this.mappingAdd(mapping, new RealizationLinkMapping(CsPackage.Literals.PHYSICAL_PATH, CsPackage.Literals.PHYSICAL_PATH, CsPackage.Literals.PHYSICAL_PATH_REALIZATION, (EStructuralFeature)CsPackage.Literals.PHYSICAL_PATH__OWNED_PHYSICAL_PATH_REALIZATIONS));
        }
        return (Collection)iContext1.get((Object)MAPPING_MAP);
    }

    private void mappingAdd(Collection<RealizationLinkMapping> mapping, RealizationLinkMapping realizationLinkMapping) {
        mapping.add(realizationLinkMapping);
    }

    protected Collection<RealizationLinkMapping> getMappingsSource(EObject targetElement, IContext context) {
        LinkedList<RealizationLinkMapping> traces = new LinkedList<RealizationLinkMapping>();
        if (targetElement instanceof CapellaElement) {
            Collection<RealizationLinkMapping> map = this.getMappings(context);
            for (RealizationLinkMapping link : map) {
                if (!link.isValidSource(targetElement, context)) continue;
                traces.add(link);
            }
        }
        if (traces.isEmpty()) {
            traces.add(this.defaultMapping);
        }
        return traces;
    }

    protected Collection<RealizationLinkMapping> getMappingsTarget(EObject targetElement, IContext context) {
        LinkedList<RealizationLinkMapping> traces = new LinkedList<RealizationLinkMapping>();
        if (targetElement instanceof CapellaElement) {
            Collection<RealizationLinkMapping> map = this.getMappings(context);
            for (RealizationLinkMapping link : map) {
                if (!link.isValidTarget(targetElement, context)) continue;
                traces.add(link);
            }
        }
        if (traces.isEmpty()) {
            traces.add(this.defaultMapping);
        }
        return traces;
    }

    protected List<EObject> getSourceAttachments(EObject targetElement, IContext context) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        Collection<RealizationLinkMapping> traces = this.getMappingsTarget(targetElement, context);
        if (targetElement instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)targetElement).getOutgoingTraces()) {
                for (RealizationLinkMapping link : traces) {
                    if (!this.isValidMapping(trace, link, context)) continue;
                    elements.add((EObject)trace.getTargetElement());
                }
            }
        }
        return elements;
    }

    protected List<EObject> getTargetAttachments(EObject sourceElement, IContext context) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        Collection<RealizationLinkMapping> traces = this.getMappingsSource(sourceElement, context);
        if (sourceElement instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)sourceElement).getIncomingTraces()) {
                for (RealizationLinkMapping link : traces) {
                    if (!this.isValidMapping(trace, link, context)) continue;
                    elements.add((EObject)trace.getSourceElement());
                }
            }
        }
        return elements;
    }

    private boolean isValidMapping(AbstractTrace trace, RealizationLinkMapping link, IContext context) {
        TraceableElement sourceElement = trace.getTargetElement();
        TraceableElement targetElement = trace.getSourceElement();
        return link.realizationLink.isInstance((Object)trace) && link.isValidSource((EObject)sourceElement, context) && link.isValidTarget((EObject)targetElement, context) && link.isValid((EObject)sourceElement, (EObject)targetElement, context);
    }

    public void attachTraceability(EObject sourceElement, EObject targetElement, IContext context) {
        if (targetElement != null) {
            this.createAttachment(sourceElement, targetElement, context);
        }
    }

    protected RealizationLinkMapping getBestMapping(EObject sourceElement, EObject targetElement, IContext context) {
        Collection<RealizationLinkMapping> map = this.getMappings(context);
        RealizationLinkMapping mapping = this.defaultMapping;
        for (RealizationLinkMapping link : map) {
            if (!link.isValidSource(sourceElement, context) || !link.isValidTarget(targetElement, context) || !link.isValid(sourceElement, targetElement, context)) continue;
            mapping = link;
            break;
        }
        if (!(mapping != this.defaultMapping || mapping.isValidSource(sourceElement, context) && mapping.isValidTarget(targetElement, context) && mapping.isValid(sourceElement, targetElement, context))) {
            mapping = null;
        }
        return mapping;
    }

    protected void createAttachment(EObject sourceElement, EObject targetElement, IContext context) {
        RealizationLinkMapping mapping = this.getBestMapping(sourceElement, targetElement, context);
        if (mapping != null) {
            EObject link = ((EPackage)mapping.realizationLink.eContainer()).getEFactoryInstance().create(mapping.realizationLink);
            if (sourceElement instanceof TraceableElement && targetElement instanceof TraceableElement) {
                ((AbstractTrace)link).setSourceElement((TraceableElement)targetElement);
                ((AbstractTrace)link).setTargetElement((TraceableElement)sourceElement);
                this.getRealizationLinks(context).add((AbstractTrace)link);
            }
        }
        this.addMappings(sourceElement, targetElement, context);
    }

    public boolean isTrace(EObject element, IContext context) {
        if (element != null) {
            if (element instanceof TransfoLink) {
                return true;
            }
            if (element.eClass().getName().endsWith("Realization") && !(element instanceof CapabilityRealization)) {
                return true;
            }
        }
        return false;
    }

    public EObject getSourceElement(EObject trace, IContext context) {
        if (trace instanceof AbstractTrace) {
            return ((AbstractTrace)trace).getTargetElement();
        }
        return null;
    }

    public EObject getTargetElement(EObject trace, IContext context) {
        if (trace instanceof AbstractTrace) {
            return ((AbstractTrace)trace).getSourceElement();
        }
        return null;
    }

    public void notifyChanged(INotifyChangeEvent event, IContext context) {
        Collection<RealizationLinkMapping> map = this.getMappings(context);
        HashMap refs = new HashMap();
        for (AbstractTrace realizationLink : this.getRealizationLinks(context)) {
            TraceableElement sourceElement = realizationLink.getSourceElement();
            TraceableElement targetElement = realizationLink.getTargetElement();
            EClass realizationLink2 = CapellacommonPackage.Literals.TRANSFO_LINK;
            EReference feature2 = CapellacorePackage.Literals.NAMESPACE__OWNED_TRACES;
            for (RealizationLinkMapping link : map) {
                if (!link.realizationLink.isInstance((Object)realizationLink) || !link.target.equals(sourceElement.eClass()) || !link.source.equals(targetElement.eClass())) continue;
                realizationLink2 = link.realizationLink;
                feature2 = link.feature;
                break;
            }
            if (realizationLink.eContainer() != null) continue;
            TraceableElement parent = sourceElement;
            EClass parentFeature = (EClass)feature2.eContainer();
            boolean isAttached = false;
            while (parent != null) {
                if (parentFeature.isInstance((Object)parent)) {
                    try {
                        ((EList)parent.eGet((EStructuralFeature)feature2)).add((Object)realizationLink);
                        isAttached = true;
                        break;
                    }
                    catch (Exception e) {
                        LogHelper.getInstance().debug(NLS.bind((String)"Realization link ''{0}'' cannot be attached into ''{1}''", (Object)realizationLink.eClass().getName(), (Object)parent.eClass().getName()), "ATTACHMENT_HANDLER");
                    }
                }
                parent = parent.eContainer();
            }
            if (isAttached) continue;
            this.getDefaultOwner(context).getOwnedTraces().add((Object)((Trace)realizationLink));
        }
    }

    protected class RealizationLinkMapping {
        protected EClass source;
        protected EClass target;
        protected EClass realizationLink;
        protected EStructuralFeature feature;

        public RealizationLinkMapping(EClass source, EClass target, EClass realizationLink, EStructuralFeature feature) {
            this.source = source;
            this.target = target;
            this.realizationLink = realizationLink;
            this.feature = feature;
        }

        public String toString() {
            return String.valueOf(this.source.getName()) + " " + this.target.getName() + " " + this.realizationLink.getName();
        }

        public boolean isValid(EObject sourceElement, EObject targetElement, IContext context) {
            if (sourceElement == null) {
                return false;
            }
            return targetElement != null;
        }

        public boolean isValidSource(EObject targetElement, IContext context) {
            if (targetElement == null) {
                return false;
            }
            return this.source.equals(targetElement.eClass());
        }

        public boolean isValidTarget(EObject targetElement, IContext context) {
            if (targetElement == null) {
                return false;
            }
            return this.target.equals(targetElement.eClass());
        }
    }
}

