/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory;

public class RichtextManager {
    private static RichtextManager instance;
    private MDENebulaBasedRichTextWidget richtextWidget;
    private Shell invisibleShell = new Shell();

    private RichtextManager() {
    }

    public static RichtextManager getInstance() {
        if (instance == null) {
            instance = new RichtextManager();
        }
        return instance;
    }

    public MDERichTextWidget getRichtextWidget(Composite parent) {
        if (this.richtextWidget == null || this.richtextWidget.isEditorDisposed()) {
            MDERichTextFactory f = new MDERichTextFactory(){

                protected MDERichTextFactory initializeMDEMinimalToolbar() {
                    MDERichTextFactory factory = super.initializeMDEMinimalToolbar();
                    ((MDENebulaRichTextConfiguration)this.getConfiguration()).removeToolbarItems(new String[]{"Subscript", "Superscript"});
                    return factory;
                }
            };
            MDERichTextWidget widget = f.createMinimalRichTextWidget(parent);
            if (widget instanceof MDENebulaBasedRichTextWidget) {
                this.richtextWidget = (MDENebulaBasedRichTextWidget)widget;
            }
        } else {
            this.richtextWidget.setParent(parent);
        }
        return this.richtextWidget;
    }

    public void removeWidget(Composite parent) {
        if (!this.invisibleShell.isDisposed() && !this.richtextWidget.isEditorDisposed() && this.richtextWidget.getParent() == parent) {
            this.richtextWidget.setParent((Composite)this.invisibleShell);
        }
    }

    public void addWidget(Composite parent) {
        if (!this.richtextWidget.isEditorDisposed() && this.richtextWidget.getParent() != parent) {
            this.richtextWidget.setParent(parent);
        }
    }

    public boolean isRichTextEnabled() {
        String property = System.getProperty("disable.nebula.richtext");
        if (property != null) {
            return Boolean.valueOf(property) == false;
        }
        return true;
    }
}

