/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.sections;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.richtext.RichtextManager;
import org.polarsys.capella.core.ui.properties.richtext.fields.CapellaElementDescriptionGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;

public class DiagramDescriptionPropertySection
extends AbstractSection {
    private WeakReference<DRepresentation> representation;
    protected CapellaElementDescriptionGroup descriptionGroup;
    private TextAreaValueGroup descriptionFallbackGroup;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        this.rootParentComposite.setLayout((Layout)new GridLayout());
        this.createDescriptionWidget(widgetFactory, this.rootParentComposite);
    }

    protected void createDescriptionWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        if (RichtextManager.getInstance().isRichTextEnabled()) {
            this.descriptionGroup = new CapellaElementDescriptionGroup(parent, widgetFactory, (ISection)this);
        } else {
            this.descriptionFallbackGroup = new TextAreaValueGroup(this.rootParentComposite, "", this.getWidgetFactory(), true);
            this.descriptionFallbackGroup.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.representation != null) {
            this.representation.clear();
            this.representation = null;
        }
        if (this.descriptionGroup != null) {
            this.descriptionGroup.dispose();
            this.descriptionGroup = null;
        }
    }

    public void historyNotification(OperationHistoryEvent event) {
        Command command;
        IUndoableOperation operation;
        int eventType = event.getEventType();
        if ((10 == eventType || 9 == eventType) && (operation = event.getOperation()) instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()).getAffectedObjects().contains(this.representation)) {
            this.refresh();
        }
    }

    public void loadData() {
        if (this.representation.get() == null) {
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        }
        this.register((EObject)this.representation.get());
        IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (roHandler != null && roHandler.isLockedByOthers((EObject)this.representation.get())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (this.descriptionGroup != null) {
            this.descriptionGroup.loadData((EObject)this.representation.get(), (EStructuralFeature)DescriptionPackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION);
        } else if (this.descriptionFallbackGroup != null) {
            this.descriptionFallbackGroup.loadData((EObject)this.representation.get(), (EStructuralFeature)DescriptionPackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION);
        }
    }

    public void refresh() {
        if (this.shouldRefresh()) {
            this.loadData();
        }
    }

    public boolean shouldRefresh() {
        return this.descriptionGroup == null || this.descriptionGroup.shouldRefresh();
    }

    public boolean select(Object toTest) {
        return toTest instanceof DRepresentationDescriptor || toTest instanceof DRepresentation || toTest instanceof IDDiagramEditPart;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty()) {
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof DRepresentationDescriptor) {
                    firstElement = ((DRepresentationDescriptor)firstElement).getRepresentation();
                }
                if (firstElement instanceof DRepresentation) {
                    this.representation = new WeakReference<DRepresentation>((DRepresentation)firstElement);
                } else if (firstElement instanceof IDDiagramEditPart) {
                    IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)firstElement;
                    this.representation = new WeakReference<DRepresentation>((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement());
                } else {
                    this.representation = null;
                }
            }
            this.loadData();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.descriptionGroup != null) {
            this.descriptionGroup.setEnabled(enabled);
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        if (this.descriptionFallbackGroup != null) {
            return Collections.singletonList(this.descriptionFallbackGroup);
        }
        return Collections.emptyList();
    }

    public void aboutToBeHidden() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeHidden();
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeShown();
        }
        super.aboutToBeShown();
    }
}

