/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.IOclEnvironmentCustomizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;

public class CapellaOclEnvironmentCustomizer
implements IOclEnvironmentCustomizer {
    private void addArchitectureVariables(SystemEngineering se_p, Collection<IOclEnvironmentCustomizer.VariableSpecification> specs_p) {
        for (ModellingArchitecture archi : se_p.getOwnedArchitectures()) {
            String name;
            IOclEnvironmentCustomizer.VariableSpecification spec = this.createVariableSpecification((EObject)archi, name = this.getArchitectureName(archi));
            if (spec == null) continue;
            specs_p.add(spec);
        }
    }

    private IOclEnvironmentCustomizer.VariableSpecification createVariableSpecification(EObject element_p, String name_p) {
        IOclEnvironmentCustomizer.VariableSpecification result = null;
        if (name_p != null) {
            EClass type = element_p != null ? element_p.eClass() : EcorePackage.eINSTANCE.getEObject();
            result = new IOclEnvironmentCustomizer.VariableSpecification(name_p, (EClassifier)type, (Object)element_p);
        }
        return result;
    }

    private String getArchitectureName(ModellingArchitecture architecture_p) {
        String result = null;
        if (architecture_p instanceof OperationalAnalysis) {
            result = "oa";
        } else if (architecture_p instanceof SystemAnalysis) {
            result = "sa";
        } else if (architecture_p instanceof LogicalArchitecture) {
            result = "la";
        } else if (architecture_p instanceof PhysicalArchitecture) {
            result = "pa";
        } else if (architecture_p instanceof EPBSArchitecture) {
            result = "epbs";
        }
        return result;
    }

    public Collection<IOclEnvironmentCustomizer.VariableSpecification> getVariables(EObject context_p) {
        ArrayList<IOclEnvironmentCustomizer.VariableSpecification> result = new ArrayList<IOclEnvironmentCustomizer.VariableSpecification>();
        SystemEngineering se = this.getSystemEngineering(context_p);
        if (se != null) {
            this.addArchitectureVariables(se, result);
        }
        return Collections.unmodifiableCollection(result);
    }

    private SystemEngineering getSystemEngineering(EObject context_p) {
        SystemEngineering result = null;
        if (context_p instanceof Project) {
            for (ModelRoot root : ((Project)context_p).getOwnedModelRoots()) {
                if (!(root instanceof SystemEngineering)) continue;
                result = (SystemEngineering)root;
                break;
            }
        } else {
            EObject current = context_p;
            while (current != null && result == null) {
                if (current instanceof SystemEngineering) {
                    result = (SystemEngineering)current;
                }
                current = current.eContainer();
            }
        }
        return result;
    }
}

