/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.data.helpers.activity.delegates;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.activity.ActivityPartition;
import org.polarsys.capella.common.data.activity.InterruptibleActivityRegion;
import org.polarsys.capella.common.data.activity.StructuredActivityNode;

public class ActivityEdgeHelper {
    private static ActivityEdgeHelper instance;

    private ActivityEdgeHelper() {
    }

    public static ActivityEdgeHelper getInstance() {
        if (instance == null) {
            instance = new ActivityEdgeHelper();
        }
        return instance;
    }

    public Object doSwitch(ActivityEdge element, EStructuralFeature feature) {
        ActivityPartition ret = null;
        if (feature.equals(ActivityPackage.Literals.ACTIVITY_EDGE__IN_ACTIVITY_PARTITION)) {
            ret = this.getInActivityPartition(element);
        } else if (feature.equals(ActivityPackage.Literals.ACTIVITY_EDGE__IN_INTERRUPTIBLE_REGION)) {
            ret = this.getInInterruptibleRegion(element);
        } else if (feature.equals(ActivityPackage.Literals.ACTIVITY_EDGE__IN_STRUCTURED_NODE)) {
            ret = this.getInStructuredNode(element);
        }
        return ret;
    }

    protected ActivityPartition getInActivityPartition(ActivityEdge element) {
        EObject group = element.eContainer();
        if (group != null && group instanceof ActivityPartition) {
            return (ActivityPartition)group;
        }
        return null;
    }

    protected InterruptibleActivityRegion getInInterruptibleRegion(ActivityEdge element) {
        EObject group = element.eContainer();
        if (group != null && group instanceof InterruptibleActivityRegion) {
            return (InterruptibleActivityRegion)group;
        }
        return null;
    }

    protected StructuredActivityNode getInStructuredNode(ActivityEdge element) {
        EObject group = element.eContainer();
        if (group != null && group instanceof StructuredActivityNode) {
            return (StructuredActivityNode)group;
        }
        return null;
    }
}

