/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.handlers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.naming.DiagramNamingConstants;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.transition.diagram.handlers.AbstractDiagramHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CapabilitiesHandler
extends AbstractDiagramHandler {
    @Override
    public boolean handles(IContext context_p, RepresentationDescription representation_p) {
        if (DiagramHelper.getService().isA(representation_p, "Operational Capabilities Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(representation_p, "Missions Capabilities Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(representation_p, "Capability Realization Blank");
    }

    @Override
    public boolean covers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Capabilities Blank")) {
            return false;
        }
        if (DiagramHelper.getService().isA(description_p, "Missions Capabilities Blank")) {
            return false;
        }
        return false;
    }

    @Override
    public boolean backCovers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Missions Capabilities Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(description_p, "Capability Realization Blank");
    }

    @Override
    public DiagramElementMapping getTargetMapping(IContext context_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p, DiagramElementMapping sourceMapping_p, EObject source_p, EObject target_p) {
        String mappingName = sourceMapping_p.getName();
        String targetMappingName = null;
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Capabilities Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Missions Capabilities Blank")) {
                if ("COC_EntityOperationalCapabilityInvolvement".equals(mappingName)) {
                    targetMappingName = "ActCapInv4";
                } else if ("COC_OperationalCapabilities".equals(mappingName)) {
                    targetMappingName = "CapabilityNode4";
                    if (target_p instanceof Mission) {
                        targetMappingName = "MissionNode4";
                    }
                } else if ("COC_OperationalEntities".equals(mappingName)) {
                    if (target_p instanceof AbstractActor) {
                        targetMappingName = "ActorNode4";
                    }
                } else {
                    "COC_CommunicationMeans".equals(mappingName);
                }
            }
        } else if (DiagramHelper.getService().isA(sourceDescription_p, "Missions Capabilities Blank") && DiagramHelper.getService().isA(targetDescription_p, "Capability Realization Blank")) {
            if ("AbsCapExtends4int".equals(mappingName)) {
                targetMappingName = "CRB Cap Realization Extends";
            } else if ("Generalization4int".equals(mappingName)) {
                targetMappingName = "CRB Cap Generalization";
            } else if ("AbsCapInclude4int".equals(mappingName)) {
                targetMappingName = "CRB Cap Realization Include";
            } else if ("actorGeneralization2".equals(mappingName)) {
                targetMappingName = "CRB Actor Generalization";
            } else if ("ActCapInv4".equals(mappingName)) {
                targetMappingName = "CRB Involvement";
            } else if ("CapabilityNode4".equals(mappingName)) {
                targetMappingName = "CRB CapabilityRealization";
            } else if ("ActorNode4".equals(mappingName)) {
                targetMappingName = "CRB Component";
            } else if (!"ActMissInv3".equals(mappingName) && !"CapExploitation4".equals(mappingName)) {
                "MissionNode4".equals(mappingName);
            }
        }
        return DiagramServices.getDiagramServices().getMappingByName(targetDescription_p, targetMappingName);
    }

    @Override
    public RepresentationDescription getTargetDescription(IContext context_p, Session session_p, RepresentationDescription description_p) {
        DiagramHelper service = DiagramHelper.getService();
        if (service.isA(description_p, "Operational Capabilities Blank")) {
            return service.getDescription(session_p, "Missions Capabilities Blank");
        }
        if (service.isA(description_p, "Missions Capabilities Blank")) {
            return service.getDescription(session_p, "Capability Realization Blank");
        }
        if (service.isA(description_p, "Capability Realization Blank")) {
            return service.getDescription(session_p, "Capability Realization Blank");
        }
        return null;
    }

    @Override
    public String getTargetName(IContext context_p, DRepresentation diagram_p, RepresentationDescription targetDescription_p) {
        RepresentationDescription description = DiagramHelper.getService().getDescription(diagram_p);
        String name = diagram_p.getName();
        name = name.replace(description.getName(), targetDescription_p.getName());
        if (DiagramHelper.getService().isA(description, "Operational Capabilities Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Missions Capabilities Blank")) {
                name = name.replace(DiagramNamingConstants.OPERATIONAL_CAPABILITIES_ENTITYIES_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.MISSIONS_CAPABILITIES_BLANK_DIAGRAM_PREFIX);
            }
        } else if (DiagramHelper.getService().isA(description, "Missions Capabilities Blank") && DiagramHelper.getService().isA(targetDescription_p, "Capability Realization Blank")) {
            name = name.replace(DiagramNamingConstants.MISSIONS_CAPABILITIES_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.CAPABILITY_REALIZATION_BLANK_DIAGRAM_PREFIX);
        }
        return name;
    }

    @Override
    public EObject getTargetDefaultLocation(IContext context_p, BlockArchitecture root_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Capabilities Blank")) {
            return BlockArchitectureExt.getFunctionPkg((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Capability Realization Blank")) {
            return BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Missions Capabilities Blank")) {
            return BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)root_p);
        }
        return null;
    }
}

