/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.helpers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.diagram.helpers.traceability.IDiagramTraceability;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.diagram.handlers.DiagramDescriptionHelper;
import org.polarsys.capella.core.transition.diagram.handlers.IDiagramHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DiagramTransitionTraceability
implements IDiagramTraceability {
    private IContext context;

    protected IDiagramHandler getHandler() {
        return DiagramDescriptionHelper.getService(this.getContext());
    }

    protected IContext getContext() {
        if (this.context == null) {
            this.context = new TransitionContext();
        }
        return this.context;
    }

    public boolean isRealizingable(DRepresentationDescriptor realizing) {
        IDiagramHandler handler = this.getHandler();
        RepresentationDescription sourceDescription = realizing.getDescription();
        if (handler == null || sourceDescription == null) {
            return false;
        }
        if (!handler.backCovers(this.getContext(), sourceDescription)) {
            return false;
        }
        return handler.backCovers(this.getContext(), realizing);
    }

    public boolean isRealizable(DRepresentationDescriptor realized, DRepresentationDescriptor realizing) {
        Session session = SessionManager.INSTANCE.getSession(realized.getTarget());
        IDiagramHandler handler = this.getHandler();
        RepresentationDescription sourceDescription = realized.getDescription();
        RepresentationDescription targetDescription = realizing.getDescription();
        if (sourceDescription == null || targetDescription == null) {
            return false;
        }
        if (!handler.covers(this.context, sourceDescription)) {
            return false;
        }
        if (!handler.covers(this.context, realized)) {
            return false;
        }
        if (!handler.backCovers(this.context, targetDescription)) {
            return false;
        }
        if (!handler.backCovers(this.context, realizing)) {
            return false;
        }
        RepresentationDescription target = this.getHandler().getTargetDescription(this.context, session, sourceDescription);
        if (target == null) {
            return false;
        }
        if (!target.equals(targetDescription)) {
            return false;
        }
        EObject sourceTarget = realized.getTarget();
        EObject targetTarget = realizing.getTarget();
        if (sourceTarget == null || targetTarget == null) {
            return false;
        }
        BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceTarget);
        BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)targetTarget);
        if (sourceArchitecture == null || targetArchitecture == null) {
            return false;
        }
        return sourceArchitecture.getAllocatingArchitectures().contains((Object)targetArchitecture);
    }

    public void dispose() {
        if (this.context != null) {
            this.context.reset();
            this.context = null;
        }
    }
}

