/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;

class BookmarkContentProvider
implements IStructuredContentProvider,
IResourceChangeListener,
IBasicPropertyConstants {
    private IResource input;
    private Viewer viewer;

    public BookmarkContentProvider(BookmarkNavigator bookmarksView) {
    }

    public void dispose() {
        IResource resource = (IResource)this.viewer.getInput();
        if (resource != null) {
            resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    Object[] getBookmarks(IResource resource) {
        try {
            return resource.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IResource) {
            return this.getBookmarks((IResource)element);
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    void getMarkerDeltas(IResourceDelta delta, List additions, List removals, List changes) {
        IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            IMarker marker = markerDelta.getMarker();
            switch (markerDelta.getKind()) {
                case 1: {
                    if (!markerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    additions.add(marker);
                    break;
                }
                case 2: {
                    if (!markerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    removals.add(marker);
                    break;
                }
                case 4: {
                    if (!markerDelta.isSubtypeOf("org.eclipse.core.resources.bookmark")) break;
                    changes.add(marker);
                }
            }
            ++n2;
        }
        iMarkerDeltaArray = delta.getAffectedChildren();
        n = iMarkerDeltaArray.length;
        n2 = 0;
        while (n2 < n) {
            IMarkerDelta child = iMarkerDeltaArray[n2];
            this.getMarkerDeltas((IResourceDelta)child, additions, removals, changes);
            ++n2;
        }
    }

    public Object getParent(Object element) {
        return this.input;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IWorkspace;
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (oldInput == null) {
            IResource resource = (IResource)newInput;
            resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.viewer = newViewer;
        this.input = (IResource)newInput;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ArrayList additions = new ArrayList();
        ArrayList removals = new ArrayList();
        ArrayList changes = new ArrayList();
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        this.getMarkerDeltas(delta, additions, removals, changes);
        if (additions.size() + removals.size() + changes.size() > 0) {
            this.viewer.getControl().getDisplay().asyncExec(() -> {
                Control ctrl = this.viewer.getControl();
                if (ctrl == null || ctrl.isDisposed()) {
                    return;
                }
                this.viewer.refresh();
            });
        }
    }
}

