/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ComponentPortAllocationEnd;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class ComponentPortAllocationExt {
    protected ComponentPortAllocationExt() {
    }

    public static Port getSourcePort(ComponentPortAllocation connection) {
        TraceableElement source = connection.getSourceElement();
        if (source instanceof ComponentPortAllocationEnd) {
            return ((ComponentPortAllocationEnd)source).getPort();
        }
        if (source instanceof Port) {
            return (Port)source;
        }
        return null;
    }

    public static Port getTargetPort(ComponentPortAllocation connection) {
        TraceableElement target = connection.getTargetElement();
        if (target instanceof ComponentPortAllocationEnd) {
            return ((ComponentPortAllocationEnd)target).getPort();
        }
        if (target instanceof Port) {
            return (Port)target;
        }
        return null;
    }

    @Deprecated
    public static Part getSourcePart(ComponentPortAllocation connection) {
        TraceableElement source = connection.getSourceElement();
        if (source instanceof ComponentPortAllocationEnd) {
            return ((ComponentPortAllocationEnd)source).getPart();
        }
        if (source instanceof Part) {
            return (Part)source;
        }
        return null;
    }

    public static Collection<Part> getSourceParts(ComponentPortAllocation connection) {
        Part part = ComponentPortAllocationExt.getSourcePart(connection);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component sourceComponent = ComponentPortAllocationExt.getSourceComponent(connection);
        if (sourceComponent != null) {
            return ComponentExt.getRepresentingParts(sourceComponent);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static Part getTargetPart(ComponentPortAllocation connection) {
        TraceableElement target = connection.getTargetElement();
        if (target instanceof ComponentPortAllocationEnd) {
            return ((ComponentPortAllocationEnd)target).getPart();
        }
        if (target instanceof Part) {
            return (Part)target;
        }
        return null;
    }

    public static Collection<Part> getTargetParts(ComponentPortAllocation connection) {
        Part part = ComponentPortAllocationExt.getTargetPart(connection);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component targetComponent = ComponentPortAllocationExt.getTargetComponent(connection);
        if (targetComponent != null) {
            return ComponentExt.getRepresentingParts(targetComponent);
        }
        return Collections.emptyList();
    }

    public static boolean attachToDefaultContainer(ComponentPortAllocation exchange) {
        return ComponentPortAllocationExt.attachTo(exchange, ComponentPortAllocationExt.getDefaultContainer(exchange));
    }

    public static boolean attachTo(ComponentPortAllocation exchange, PhysicalPort container) {
        if (container != null && !container.equals(exchange.eContainer())) {
            container.getOwnedComponentPortAllocations().add((Object)exchange);
            return true;
        }
        return false;
    }

    public static PhysicalPort getDefaultContainer(ComponentPortAllocation exchange) {
        return (PhysicalPort)ComponentPortAllocationExt.getSourcePort(exchange);
    }

    public static Component getSourceComponent(ComponentPortAllocation connection) {
        TraceableElement source = connection.getSourceElement();
        if (source instanceof ComponentPortAllocationEnd) {
            Type abstractType;
            Part part = ((ComponentPortAllocationEnd)source).getPart();
            if (part != null && (abstractType = part.getType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (source instanceof Part) {
            Part part = (Part)source;
            Type abstractType = part.getType();
            if (abstractType != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (source instanceof ComponentPort) {
            EObject eContainer = source.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (source instanceof PhysicalPort) {
            EObject eContainer = source.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (source instanceof Component) {
            return (Component)source;
        }
        return null;
    }

    public static Component getTargetComponent(ComponentPortAllocation connection) {
        TraceableElement target = connection.getTargetElement();
        if (target instanceof ComponentPortAllocationEnd) {
            Type abstractType;
            Part part = ((ComponentPortAllocationEnd)target).getPart();
            if (part != null && (abstractType = part.getType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (target instanceof Part) {
            Part part = (Part)target;
            Type abstractType = part.getType();
            if (abstractType != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (target instanceof ComponentPort) {
            EObject eContainer = target.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (target instanceof PhysicalPort) {
            EObject eContainer = target.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (target instanceof Component) {
            return (Component)target;
        }
        return null;
    }
}

