/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;

public class FunctionalExchangeExt {
    public static AbstractFunction getSourceFunction(FunctionalExchange exchange) {
        return FunctionExt.getRelatedFunction((ActivityNode)exchange.getSource());
    }

    public static AbstractFunction getTargetFunction(FunctionalExchange exchange) {
        return FunctionExt.getRelatedFunction((ActivityNode)exchange.getTarget());
    }

    public static FunctionalExchange createFunctionalExchange(ActivityNode sourceNode, ActivityNode targetNode) {
        ActivityNode exchangeSourceNode = sourceNode;
        ActivityNode exchangeTargetNode = targetNode;
        AbstractFunction sourceFunction = FunctionExt.getRelatedFunction((ActivityNode)sourceNode);
        AbstractFunction targetFunction = FunctionExt.getRelatedFunction((ActivityNode)targetNode);
        if (!(sourceNode instanceof FunctionPort) && !(sourceNode instanceof OperationalActivity)) {
            exchangeSourceNode = FaFactory.eINSTANCE.createFunctionOutputPort();
            sourceFunction.getOutputs().add((Object)((FunctionOutputPort)exchangeSourceNode));
            CapellaElementExt.creationService((EObject)exchangeSourceNode);
        }
        if (!(targetNode instanceof FunctionPort) && !(targetNode instanceof OperationalActivity)) {
            exchangeTargetNode = FaFactory.eINSTANCE.createFunctionInputPort();
            targetFunction.getInputs().add((Object)((FunctionInputPort)exchangeTargetNode));
            CapellaElementExt.creationService((EObject)exchangeTargetNode);
        }
        FunctionalExchange exchange = FaFactory.eINSTANCE.createFunctionalExchange();
        exchange.setSource(exchangeSourceNode);
        exchange.setTarget(exchangeTargetNode);
        FunctionalExchangeExt.attachToDefaultContainer(exchange);
        CapellaElementExt.creationService((EObject)exchange);
        return exchange;
    }

    public static boolean attachTo(FunctionalExchange exchange, AbstractFunction container) {
        if (container != null && !container.equals(exchange.eContainer())) {
            container.getOwnedFunctionalExchanges().add((Object)exchange);
            return true;
        }
        return false;
    }

    public static boolean attachToDefaultContainer(FunctionalExchange exchange) {
        return FunctionalExchangeExt.attachTo(exchange, FunctionalExchangeExt.getDefaultContainer(exchange));
    }

    public static AbstractFunction getDefaultContainer(AbstractFunction sourceFunction, AbstractFunction targetFunction) {
        EObject container = EcoreUtil2.getCommonAncestor((EObject)sourceFunction, (EObject)targetFunction);
        if (container != null && !(container instanceof AbstractFunction)) {
            container = EcoreUtil2.getFirstContainer((EObject)container, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
        }
        if (container == null || !(container instanceof AbstractFunction)) {
            container = BlockArchitectureExt.getRootFunction(BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceFunction));
        }
        return (AbstractFunction)container;
    }

    public static AbstractFunction getDefaultContainer(FunctionalExchange exchange) {
        AbstractFunction source = FunctionalExchangeExt.getSourceFunction(exchange);
        AbstractFunction target = FunctionalExchangeExt.getTargetFunction(exchange);
        return FunctionalExchangeExt.getDefaultContainer(source, target);
    }
}

