/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.properties.controllers.RepresentationContextualElementsController;
import org.polarsys.capella.core.ui.properties.fields.BrowseSemanticField;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.helpers.NamingHelper;

public class RepresentationContextualElementsField
extends BrowseSemanticField {
    protected WeakReference<DRepresentationDescriptor> descriptor;
    protected RepresentationContextualElementsController controller;

    public RepresentationContextualElementsField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, RepresentationContextualElementsController controller) {
        this(parent, label, widgetFactory, 3, controller, false);
    }

    public RepresentationContextualElementsField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, int textFieldSpan, RepresentationContextualElementsController controller, boolean hasAddBtn) {
        super(parent, label, widgetFactory, textFieldSpan);
        this.controller = controller;
        if (hasAddBtn) {
            this.createAddButton(parent);
        }
        this.createOpenButton(parent);
        this.createDeleteButton(parent);
    }

    public void loadData(DRepresentationDescriptor dRepresentation) {
        this.descriptor = new WeakReference<DRepresentationDescriptor>(dRepresentation);
        this.setValueTextField(this.controller.loadValues((EObject)dRepresentation));
    }

    @Override
    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)((EObject)this.descriptor.get()));
    }

    @Override
    protected void handleOpenButtonClicked(final Button button) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                List<EObject> currentElements = RepresentationContextualElementsField.this.controller.readOpenValues((EObject)RepresentationContextualElementsField.this.descriptor.get(), false);
                List<EObject> availableElements = RepresentationContextualElementsField.this.controller.readOpenValues((EObject)RepresentationContextualElementsField.this.descriptor.get(), true);
                availableElements.removeAll(currentElements);
                String title = ((DRepresentationDescriptor)RepresentationContextualElementsField.this.descriptor.get()).getName();
                String message = NamingHelper.getDefaultMessage((EObject)RepresentationContextualElementsField.this.descriptor.get(), "contextual elements");
                List<EObject> allResults = DialogHelper.openTransferDialog((Control)button, currentElements, availableElements, title, message);
                if (allResults != null) {
                    List<EObject> writeOpenValues = RepresentationContextualElementsField.this.controller.writeOpenValues((EObject)RepresentationContextualElementsField.this.descriptor.get(), allResults);
                    RepresentationContextualElementsField.this.setValueTextField(writeOpenValues);
                }
            }
        };
        this.executeCommand((ICommand)command);
    }

    @Override
    protected void handleDeleteButtonClicked() {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                ArrayList<EObject> allResults = new ArrayList<EObject>();
                List<EObject> writeOpenValues = RepresentationContextualElementsField.this.controller.writeOpenValues((EObject)RepresentationContextualElementsField.this.descriptor.get(), allResults);
                RepresentationContextualElementsField.this.setValueTextField(writeOpenValues);
            }
        };
        this.executeCommand((ICommand)command);
    }
}

