/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.viewers;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.viewers.AbstractDelegatedViewer;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class TableDelegatedViewer
extends AbstractDelegatedViewer {
    protected Table _table;

    public TableDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory) {
        this(widgetFactory, null);
    }

    public TableDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory, ICellEditorProvider cellEditorProvider) {
        super(widgetFactory, cellEditorProvider);
    }

    @Override
    public void createContainer(Composite parent) {
        this._table = this._widgetFactory.createTable(this.getViewerGroup(parent), 67586);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.horizontalSpan = 5;
        this._table.setLayoutData((Object)tableLayoutData);
        this._columnViewer = new TableViewer(this._table);
        this._columnViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._columnViewer.setLabelProvider((IBaseLabelProvider)new CapellaElementLabelProvider());
        this.addViewerListeners();
        if (this.createViewerColumns()) {
            this._table.setHeaderVisible(true);
            this._table.setLinesVisible(true);
        }
        this.createCellEditors((Composite)this._table);
    }

    protected TableViewerColumn createTableViewerColumn(int colNumber, ColumnLabelProvider labelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.getColumnViewer(), 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.getColumnProperties()[colNumber]);
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        return viewerColumn;
    }

    @Override
    public void setInput(List<EObject> input) {
        if (this._columnViewer != null) {
            this._columnViewer.setInput(input);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._table != null && !this._table.isDisposed()) {
            this._table.setEnabled(enabled);
        }
    }
}

