/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.refinement.scenarios.core.Messages;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public abstract class StaticRefinement
implements IProcessor {
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    protected ModelElement _context = null;
    protected NamedElement _target = null;
    private List<IProcessor> pluggedProcessors = new ArrayList<IProcessor>();

    @Override
    public void setContext(ModelElement context) {
        this._context = context;
    }

    @Override
    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    @Override
    public void setTarget(NamedElement target) {
        this._target = target;
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void addPlug(IProcessor processor) {
        this.addPlug(-1, processor);
    }

    public void addPlug(int order, IProcessor processor) {
        if (this.pluggedProcessors == null) {
            this.pluggedProcessors = new ArrayList<IProcessor>();
        }
        if (order < 0 || order > this.pluggedProcessors.size()) {
            this.pluggedProcessors.add(processor);
        } else {
            this.pluggedProcessors.add(order, processor);
        }
    }

    @Override
    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        try {
            for (IProcessor processor : this.pluggedProcessors) {
                processor.execute(progressMonitor);
                Object processorName = processor.getName();
                if (processorName == null) continue;
                String loggedMsg = MessageFormat.format(Messages.Processing_Succeeded, processor.getName());
                this._logger.info((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._context));
            }
        }
        catch (ProcessorException ex) {
            String loggedMsg = MessageFormat.format(Messages.Processing_Failed, ex.getPlug().getName());
            this._logger.error((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this._context));
        }
    }
}

