/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core.datastructures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class Node<T> {
    public Node<T> relatedNode = null;
    public Node<T> oppositeNode = null;
    protected Node<T> parent = null;
    protected Node<T> previous = null;
    protected Node<T> next = null;
    protected Node<T> head = null;
    private T data = null;
    private int level = 0;

    public Node(Node<T> parent) {
        this.setParent(parent);
        if (this.parent != null) {
            this.level = this.parent.level + 1;
        }
    }

    public Node(Node<T> parent, T data) {
        this(parent);
        this.setData(data);
    }

    public List<Node<T>> getChildren() {
        ArrayList<Node<T>> children = new ArrayList<Node<T>>();
        Node<T> childNode = this.head;
        while (childNode != null) {
            children.add(childNode);
            childNode = childNode.next;
        }
        return children;
    }

    public int getNumberOfChildren() {
        int size = 0;
        Node<T> childNode = this.head;
        while (childNode != null) {
            ++size;
            childNode = childNode.next;
        }
        return size;
    }

    public void addLastChild(Node<T> child) {
        Node<T> lastChild = this.getLastChildNode();
        if (lastChild != null) {
            lastChild.next = child;
        } else {
            this.head = child;
        }
        child.previous = lastChild;
        child.next = null;
        child.parent = this;
        child.level = this.level + 1;
    }

    public void addFirstChild(Node<T> child) {
        Node<T> firstChild = this.getFirstChildNode();
        if (firstChild != null) {
            firstChild.previous = child;
        }
        child.previous = null;
        child.next = firstChild;
        child.parent = this;
        child.level = this.level + 1;
        this.head = child;
    }

    public void addChildAfter(Node<T> child, Node<T> previousNode) {
        if (previousNode != null) {
            Node<T> childNode = this.head;
            while (childNode != null) {
                if (childNode == previousNode) {
                    Node<T> nextNode = previousNode.next;
                    child.previous = previousNode;
                    child.next = nextNode;
                    child.parent = this;
                    child.level = this.level + 1;
                    previousNode.next = child;
                    if (nextNode != null) {
                        nextNode.previous = child;
                    }
                }
                childNode = childNode.next;
            }
        } else {
            this.addFirstChild(child);
        }
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public void setParent(Node<T> parent) {
        this.parent = parent;
    }

    public Node<T> getPreviousNode() {
        return this.previous;
    }

    public Node<T> getNextNode() {
        return this.next;
    }

    public Node<T> getFirstNode() {
        return this.previous == null ? this : this.previous.getFirstNode();
    }

    public Node<T> getLastNode() {
        return this.next == null ? this : this.next.getLastNode();
    }

    public Node<T> getFirstChildNode() {
        return this.head;
    }

    public Node<T> getLastChildNode() {
        return this.head == null ? null : this.head.getLastNode();
    }

    public boolean isParentOf(Node<T> node) {
        Node<T> childNode = this.head;
        while (childNode != null) {
            if (childNode == node) {
                return true;
            }
            childNode = childNode.next;
        }
        return false;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Node<T> getFirstLinkedParent() {
        Node<T> returnedNode = null;
        Node<T> parentNode = this.getParent();
        if (parentNode != null) {
            returnedNode = parentNode.relatedNode != null ? parentNode : parentNode.getFirstLinkedParent();
        }
        return returnedNode;
    }

    public Node<T> getFirstParentInstanceOf(EClass eclass) {
        Node<T> returnedNode = null;
        if (((EObject)this.data).eClass().isSuperTypeOf(eclass)) {
            returnedNode = this;
        } else {
            Node<T> parentNode = this.getParent();
            if (parentNode != null) {
                returnedNode = parentNode.getFirstParentInstanceOf(eclass);
            }
        }
        return returnedNode;
    }

    public Node<T> getFirstLinkedPredecessor() {
        Node<T> parentNode = this.getParent();
        Node<T> previousNode = this.getPreviousNode();
        Node<T> returnedNode = null;
        if (previousNode != null) {
            returnedNode = previousNode.findPreviousLinkedNode();
            if (returnedNode == null) {
                returnedNode = previousNode.relatedNode != null ? previousNode : previousNode.getFirstLinkedPredecessor();
            }
        } else if (parentNode != null) {
            returnedNode = parentNode.getFirstLinkedPredecessor();
        }
        return returnedNode;
    }

    public Node<T> findPreviousLinkedNode() {
        Node<T> lastChild = null;
        Node returnedNode = null;
        lastChild = this.getLastChildNode();
        while (lastChild != null && returnedNode == null) {
            returnedNode = lastChild.findPreviousLinkedNode();
            lastChild = lastChild.getPreviousNode();
        }
        if (returnedNode == null && this.relatedNode != null) {
            returnedNode = this;
        }
        return returnedNode;
    }

    public String toString() {
        String data = "";
        StringBuilder sb = new StringBuilder();
        if (this.getData() != null) {
            data = this.getData().toString();
        }
        sb.append("{").append(data).append(",[");
        int i = 0;
        Node<T> childNode = this.head;
        while (childNode != null) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(childNode.getData().toString());
            ++i;
            childNode = childNode.next;
        }
        sb.append("]").append("}");
        return sb.toString();
    }
}

