/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChain;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.validation.functionalChain.Messages;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_FunctionalChain_Involvements_1
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof FunctionalChain) {
            FunctionalChain chain = (FunctionalChain)eObj;
            if (chain.getOwnedFunctionalChainInvolvements().isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_IsEmpty});
            }
            String involvedElements = "";
            ArrayList<FunctionalChainInvolvement> invsNoValid = new ArrayList<FunctionalChainInvolvement>();
            for (FunctionalChainInvolvement inv : chain.getOwnedFunctionalChainInvolvements()) {
                IStatus status = FunctionalChainExt.isFunctionalChainInvolvementValidWithStatus((FunctionalChainInvolvement)inv);
                if (status.isOK()) continue;
                involvedElements = String.valueOf(involvedElements) + EObjectLabelProviderHelper.getText((EObject)inv);
                involvedElements = String.valueOf(involvedElements) + ' ';
                involvedElements = String.valueOf(involvedElements) + '(';
                involvedElements = String.valueOf(involvedElements) + status.getMessage();
                involvedElements = String.valueOf(involvedElements) + ')';
                involvedElements = String.valueOf(involvedElements) + '\n';
                invsNoValid.add(inv);
            }
            if (!invsNoValid.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), NLS.bind((String)Messages.MDCHK_FunctionalChain_Involvements_1_InvolvementInvalid, (Object)String.valueOf(invsNoValid.size()), (Object)involvedElements)});
            }
            if (!FunctionalChainExt.isFunctionalChainWellFormed((FunctionalChain)chain)) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_NotWellFormed});
            }
            EList sources = chain.getFirstFunctionalChainInvolvements();
            if (sources.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_NoSource});
            }
            boolean cycleFound = FunctionalChainExt.containsACycle((FunctionalChain)chain);
            if (cycleFound) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_ContainsACycle});
            }
        }
        return ctx.createSuccessStatus();
    }
}

