/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.data;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;

public class DataContentProvider
implements ITreeContentProvider {
    private Class<?> _classFilter;
    private AbstractData _dataInput;
    private EObject _eObjectFilter;
    private AbstractTreeViewer _viewer;
    private boolean expandAddedContent = false;

    public DataContentProvider() {
        this((EObject)null);
    }

    public DataContentProvider(Class<?> classFilter) {
        this._classFilter = classFilter;
    }

    public DataContentProvider(EObject objectFilter) {
        this._eObjectFilter = objectFilter;
    }

    public void dispose() {
        this._dataInput = null;
    }

    protected Object[] filter(Object[] elements) {
        Object[] result = elements;
        if (this._classFilter != null || this._eObjectFilter != null) {
            ArrayList<Object> filteredElements = new ArrayList<Object>(0);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject && EcoreUtil2.isContainedBy((EObject)((EObject)object), (EObject)this._eObjectFilter)) {
                    filteredElements.add(object);
                }
                ++n2;
            }
            result = filteredElements.toArray();
        }
        return result;
    }

    public Object[] getChildren(Object element) {
        return this.filter(this._dataInput.getChildren(element));
    }

    public Class<?> getClassFilter() {
        return this._classFilter;
    }

    public Object[] getElements(Object element) {
        return this.filter(this._dataInput.getElements());
    }

    public EObject getObjectFilter() {
        return this._eObjectFilter;
    }

    public Object getParent(Object element) {
        return this._dataInput.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this._viewer == null) {
            if (newInput instanceof AbstractData) {
                this._viewer = (AbstractTreeViewer)viewer;
                this._dataInput = (AbstractData)newInput;
            }
        } else {
            boolean shouldRefresh = false;
            boolean addedContent = false;
            if (newInput instanceof Object[]) {
                this._dataInput.addAllElements((Object[])newInput);
                shouldRefresh = true;
                addedContent = true;
            } else if (newInput instanceof AbstractData) {
                this._dataInput = (AbstractData)newInput;
            } else if (oldInput instanceof Object[]) {
                this._dataInput.removeAllElements((Object[])oldInput);
                shouldRefresh = true;
            }
            if (shouldRefresh) {
                this._viewer.refresh();
                if (addedContent && this.isExpandingNewContent()) {
                    Object[] objectArray = (Object[])newInput;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        this._viewer.expandToLevel(o, 0);
                        ++n2;
                    }
                }
                this._dataInput.notifyValidElementsChanges();
            }
        }
    }

    public boolean isExpandingNewContent() {
        return this.expandAddedContent;
    }

    public void setExpandingNewContent(boolean b) {
        this.expandAddedContent = b;
    }

    public void setClassFilter(Class<?> classFilter) {
        this._classFilter = classFilter;
    }

    public void setObjectFilter(EObject objectFilter) {
        this._eObjectFilter = objectFilter;
    }
}

