/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointsFolderItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;

public class CapellaArchitectureContentProvider
extends AdapterFactoryContentProvider {
    private static final Object[] NO_CHILD = new Object[0];
    private EClass _filteringMetaClassForCommonViewpoint;
    private Set<String> _handledViewpoint;

    public CapellaArchitectureContentProvider(Set<String> handledViewpoint, EClass filteringMetaClassForCommonViewpoint) {
        super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
        this._handledViewpoint = handledViewpoint;
        this._filteringMetaClassForCommonViewpoint = filteringMetaClassForCommonViewpoint;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = NO_CHILD;
        if (parentElement instanceof Session) {
            result = this.getSessionChildren((Session)parentElement);
        } else if (parentElement instanceof ViewpointItem) {
            ViewpointItem viewpointItem = (ViewpointItem)parentElement;
            result = this.handleViewPointItem(parentElement, viewpointItem.getChildren());
        } else if (parentElement instanceof RepresentationDescriptionItem) {
            RepresentationDescriptionItem representationDescriptionItem = (RepresentationDescriptionItem)parentElement;
            Collection representationItems = representationDescriptionItem.getChildren();
            RepresentationDescription representationDescription = (RepresentationDescription)representationDescriptionItem.getWrappedObject();
            Viewpoint viewpoint = (Viewpoint)representationDescription.eContainer();
            if ("Common".equals(viewpoint.getName())) {
                Iterator iterator = representationItems.iterator();
                while (iterator.hasNext()) {
                    DRepresentationDescriptor representationDescriptor;
                    BlockArchitecture rootBlockArchitecture;
                    Object item = iterator.next();
                    if (item instanceof ItemWrapper) {
                        item = ((ItemWrapper)item).getWrappedObject();
                    }
                    if (!(item instanceof DRepresentationDescriptor) || (rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)(representationDescriptor = (DRepresentationDescriptor)item).getTarget())) != null && this._filteringMetaClassForCommonViewpoint.isSuperTypeOf(rootBlockArchitecture.eClass())) continue;
                    iterator.remove();
                }
            }
            if (!representationItems.isEmpty()) {
                result = representationItems.toArray();
            }
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private Object[] getSessionChildren(Session session) {
        ViewpointsFolderItemImpl viewpointsFolderItem = new ViewpointsFolderItemImpl(session, (Object)session);
        Collection viewpointItems = viewpointsFolderItem.getChildren();
        Iterator iterator = viewpointItems.iterator();
        while (iterator.hasNext()) {
            ViewpointItem viewpointItem;
            Viewpoint viewpoint;
            String viewpointName;
            Object item = iterator.next();
            if (!(item instanceof ViewpointItem) || "Common".equals(viewpointName = (viewpoint = (Viewpoint)(viewpointItem = (ViewpointItem)item).getWrappedObject()).getName()) || !this._handledViewpoint.iterator().hasNext() || viewpointName.equals(this._handledViewpoint.iterator().next())) continue;
            iterator.remove();
        }
        return viewpointItems.toArray();
    }

    private Object[] handleViewPointItem(Object element, Collection<? extends Object> children) {
        ArrayList<Object> result = new ArrayList<Object>(children);
        if (element instanceof ViewpointItem) {
            ArrayList selectedChildren = new ArrayList(0);
            for (Object e : result) {
                ItemWrapper item = (ItemWrapper)e;
                Collection itemChildren = item.getChildren();
                if (itemChildren.isEmpty() || this.getChildren(e).length <= 0) continue;
                selectedChildren.add(e);
            }
            result = selectedChildren;
        }
        return result.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

