/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.handler;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.ui.search.FindAndReplaceDialog;

public class FindReplaceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event_p);
        ModelElement modelElement = this.getSelectedModelElement(selection);
        SystemEngineering root = CapellaQueries.getInstance().getRootQueries().getSystemEngineering(modelElement);
        if (root == null) {
            return null;
        }
        HashSet rootContents = (HashSet)EcoreUtil2.getAllContents(Collections.singletonList(root));
        FindAndReplaceDialog dialog = new FindAndReplaceDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event_p).getShell(), root, rootContents, selection, 2);
        dialog.open();
        return null;
    }

    public ModelElement getSelectedModelElement(ISelection selection_p) {
        if (!(selection_p instanceof IStructuredSelection)) {
            return null;
        }
        Object selectedElement = ((IStructuredSelection)selection_p).getFirstElement();
        if (selectedElement instanceof ModelElement) {
            return (ModelElement)selectedElement;
        }
        return null;
    }

    public ISelection getCurrentSelection(Object evaluationContext_p) {
        IWorkbenchPart activePart = (IWorkbenchPart)HandlerUtil.getVariable((Object)evaluationContext_p, (String)"activePart");
        if (activePart == null) {
            return StructuredSelection.EMPTY;
        }
        if (activePart.getSite().getSelectionProvider() == null) {
            return StructuredSelection.EMPTY;
        }
        return activePart.getSite().getSelectionProvider().getSelection();
    }

    public void setEnabled(Object evaluationContext_p) {
        ISelection selection = this.getCurrentSelection(evaluationContext_p);
        ModelElement selectedElement = this.getSelectedModelElement(selection);
        if (selectedElement != null && selectedElement instanceof CapellaElement) {
            this.setBaseEnabled(true);
            return;
        }
        this.setBaseEnabled(false);
    }
}

