/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.configuration.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.core.preferences.configuration.project.IDefaultProjectLocationProvider;
import org.polarsys.capella.core.preferences.configuration.project.ProjectContentsLocationArea;

public class ConfigurationProjectContentsLocationArea
extends ProjectContentsLocationArea {
    private IDefaultProjectLocationProvider _defaultProjectLocationProvider;

    public ConfigurationProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter_p, Composite composite_p, IProject startProject_p) {
        super(reporter_p, composite_p, startProject_p);
    }

    public ConfigurationProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter_p, Composite composite_p) {
        super(reporter_p, composite_p);
    }

    @Override
    protected void createContents(Composite composite_p, boolean defaultEnabled_p) {
        super.createContents(composite_p, defaultEnabled_p);
        this.updateLocationField(this.getDefaultPathDisplayString());
    }

    protected IDefaultProjectLocationProvider getDefaultProjectLocationContribution() {
        return null;
    }

    @Override
    protected String getDefaultPathDisplayString() {
        if (this._defaultProjectLocationProvider == null) {
            this._defaultProjectLocationProvider = this.getDefaultProjectLocationContribution();
        }
        if (this._defaultProjectLocationProvider == null) {
            return super.getDefaultPathDisplayString();
        }
        String defaultProjectLocation = this._defaultProjectLocationProvider.getDefaultProjectLocation();
        return defaultProjectLocation == null ? super.getDefaultPathDisplayString() : new Path(defaultProjectLocation).append(this.getProjectName()).toString();
    }

    @Override
    public void updateProjectName(String newName_p) {
        super.updateProjectName(newName_p);
        if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked()) {
            this.updateLocationField(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    @Override
    public String checkValidLocation() {
        String isValid = super.checkValidLocation();
        if (isValid == null) {
            String projectName = this.getProjectName();
            if (projectName.contains("&")) {
                isValid = NLS.bind((String)"ForbiddenCharacter", (Object)Character.valueOf('&'));
                return isValid;
            }
            Object projectFolder = null;
            String defaultPathDisplayString = this.getDefaultPathDisplayString();
            if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked()) {
                if (!"".equals(defaultPathDisplayString)) {
                    projectFolder = new Path(defaultPathDisplayString);
                } else {
                    isValid = this._defaultProjectLocationProvider.getErrorMessage();
                }
            } else {
                projectFolder = this.isDefault() ? new Path(defaultPathDisplayString) : new Path(this.getProjectLocation()).append(projectName);
            }
            if (projectFolder != null && projectFolder.toFile().exists()) {
                isValid = "FolderAlreadyExists";
            }
        }
        return isValid;
    }

    @Override
    public String getProjectLocation() {
        String projectLocation = super.getProjectLocation();
        if (this._defaultProjectLocationProvider != null && this.isUseDefaultButtonChecked() && this._defaultProjectLocationProvider.getDefaultProjectLocation() != null) {
            projectLocation = new Path(projectLocation).removeLastSegments(1).toString();
        }
        return projectLocation;
    }

    protected boolean isUseDefaultButtonChecked() {
        return this.useDefaultsButton.getSelection();
    }

    @Override
    public boolean isDefault() {
        if (this._defaultProjectLocationProvider == null || this._defaultProjectLocationProvider.getDefaultProjectLocation() == null) {
            return super.isDefault();
        }
        return false;
    }
}

