/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.command.Messages;

public class BasicRepresentationDeleteCommand
extends RecordingCommand {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private Collection<DRepresentationDescriptor> descriptors;
    private IProgressMonitor monitor;

    public BasicRepresentationDeleteCommand(TransactionalEditingDomain domain, Collection<DRepresentationDescriptor> descriptors, IProgressMonitor monitor) {
        super(domain, Messages.DeleteRepresentationCommand_DeleteRepresentationCommandLabel);
        this.descriptors = descriptors;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.descriptors == null || this.descriptors.size() == 0) {
            return;
        }
        try {
            this.monitor.beginTask(this.description, this.descriptors.size());
            for (DRepresentationDescriptor descriptor : this.descriptors) {
                if (descriptor.getName() != null) {
                    this.monitor.setTaskName(NLS.bind((String)Messages.DeleteRepresentationCommand_DeleteRepresentationCommandText, (Object)descriptor.getName()));
                }
                Session session = null;
                EObject targetElement = descriptor.getTarget();
                if (targetElement != null) {
                    session = SessionManager.INSTANCE.getSession(targetElement);
                }
                if (session == null) {
                    session = this.getSession(descriptor.eResource());
                }
                if (session != null) {
                    this.closeActiveRepresentationEditor(descriptor, session);
                    if (DialectManager.INSTANCE.deleteRepresentation(descriptor, session)) {
                        SessionManager.INSTANCE.notifyRepresentationDeleted(session);
                    }
                } else {
                    StringBuilder loggerMessage = new StringBuilder("DeleteRepresentationAction.DeleteRepresentationCommand.doExecute(..) _ ");
                    loggerMessage.append("unable to find a session for ").append(descriptor.toString());
                    logger.error((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"));
                }
                this.monitor.worked(1);
            }
        }
        finally {
            this.monitor.done();
        }
    }

    protected void closeActiveRepresentationEditor(DRepresentationDescriptor representation, Session session) {
    }

    private Session getSession(Resource airdResource) {
        Session result = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            HashSet<Resource> allAnalysisResources = new HashSet<Resource>(session.getReferencedSessionResources());
            allAnalysisResources.add(session.getSessionResource());
            if (!allAnalysisResources.contains(airdResource)) continue;
            result = session;
            break;
        }
        return result;
    }
}

