/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.handlers.log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.log.ILogHandler;

public class DebugTraceLogHandler
implements ILogHandler {
    protected Logger _logger;
    String reportComponent;

    public DebugTraceLogHandler(String reportComponent_p) {
        this.reportComponent = reportComponent_p;
    }

    @Override
    public void init(IContext context_p) {
        this._logger = ReportManagerRegistry.getInstance().subscribe(this.reportComponent);
    }

    @Override
    public void dispose(IContext context_p) {
    }

    @Override
    public void log(String message_p, String priority_p, Object relatedObjects_p, String source_p) {
        if (this._logger.isEnabledFor((Priority)Level.toLevel((String)priority_p))) {
            EmbeddedMessage mess = new EmbeddedMessage(message_p, this._logger.getName(), relatedObjects_p);
            mess.setSource(source_p);
            this._logger.log((Priority)Level.toLevel((String)priority_p), (Object)mess);
        }
    }

    @Override
    public void log(String message_p, String priority_p, String source_p) {
        this.log(message_p, priority_p, null, source_p);
    }

    @Override
    public void debug(String message_p, Object relatedObjects_p, String source_p) {
        this.log(message_p, "DEBUG", relatedObjects_p, source_p);
    }

    @Override
    public void debug(String message_p, String source_p) {
        this.log(message_p, "DEBUG", source_p);
    }

    @Override
    public void info(String message_p, Object relatedObjects_p, String source_p) {
        this.log(message_p, "INFO", relatedObjects_p, source_p);
    }

    @Override
    public void info(String message_p, String source_p) {
        this.log(message_p, "INFO", source_p);
    }

    @Override
    public void warn(String message_p, Object relatedObjects_p, String source_p) {
        this.log(message_p, "WARN", relatedObjects_p, source_p);
    }

    @Override
    public void warn(String message_p, String source_p) {
        this.log(message_p, "WARN", source_p);
    }

    @Override
    public void error(String message_p, Object relatedObjects_p, String source_p) {
        this.log(message_p, "ERROR", relatedObjects_p, source_p);
    }

    @Override
    public void error(String message_p, String source_p) {
        this.log(message_p, "ERROR", source_p);
    }

    @Override
    public void fatal(String message_p, Object relatedObjects_p, String source_p) {
        this.log(message_p, "FATAL", relatedObjects_p, source_p);
    }

    @Override
    public void fatal(String message_p, String source_p) {
        this.log(message_p, "FATAL", source_p);
    }

    @Override
    public String getText(Object object_p) {
        if (object_p != null) {
            if (object_p instanceof EObject) {
                return EObjectLabelProviderHelper.getText((EObject)((EObject)object_p));
            }
            return object_p.toString();
        }
        return ProjectionMessages.Null;
    }
}

