/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.dialogs.Messages;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.SelectInvokedOperationModel;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.AbstractCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController.SelectInvokedOperationView;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;

public class SelectInvokedOperationController {
    protected SelectInvokedOperationModel model;
    protected SelectInvokedOperationView view;

    public SelectInvokedOperationController(SelectInvokedOperationModel model) {
        this.model = model;
    }

    public void selectionHasChanged(ISelection selection) {
        Object selectedElement;
        Object object = selectedElement = selection == null || selection.isEmpty() ? null : ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement instanceof AbstractCommunication) {
            this.model.setSelectedElement((AbstractCommunication)selectedElement);
        } else {
            this.model.setSelectedElement(null);
        }
        this.updateWindow();
    }

    protected void initControlOnView(SelectInvokedOperationView vw) {
        this.view = vw;
        this.view.synchronousRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setMessageKind(MessageKind.SYNCHRONOUS_CALL);
                if (SelectInvokedOperationController.this.model.doesElementMustBeCreated()) {
                    SelectInvokedOperationController.this.updateRadioButtons();
                } else {
                    SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
                }
            }
        });
        this.view.asynchronousRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setMessageKind(MessageKind.ASYNCHRONOUS_CALL);
                if (SelectInvokedOperationController.this.model.doesElementMustBeCreated()) {
                    SelectInvokedOperationController.this.updateRadioButtons();
                } else {
                    SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
                }
            }
        });
        this.view.createElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean elementCreation = ((Button)event.widget).getSelection();
                SelectInvokedOperationController.this.model.setElementMustBeCreated(elementCreation);
                if (elementCreation) {
                    SelectInvokedOperationController.this.model.setSelectedElement(null);
                } else {
                    SelectInvokedOperationController.this.model.setSelectedElement(SelectInvokedOperationController.this.view.getSelectedElement());
                }
                SelectInvokedOperationController.this.updateWindow();
                if (!elementCreation) {
                    SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
                }
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button == SelectInvokedOperationController.this.view.operationRadioButton) {
                    SelectInvokedOperationController.this.model.setSelectedExchangeMechanism(ExchangeMechanism.OPERATION);
                } else if (button == SelectInvokedOperationController.this.view.eventRadioButton) {
                    SelectInvokedOperationController.this.model.setSelectedExchangeMechanism(ExchangeMechanism.EVENT);
                } else if (button == SelectInvokedOperationController.this.view.flowRadioButton) {
                    SelectInvokedOperationController.this.model.setSelectedExchangeMechanism(ExchangeMechanism.FLOW);
                } else if (button == SelectInvokedOperationController.this.view.sharedRadioButton) {
                    SelectInvokedOperationController.this.model.setSelectedExchangeMechanism(ExchangeMechanism.SHARED_DATA);
                } else {
                    SelectInvokedOperationController.this.model.setSelectedExchangeMechanism(ExchangeMechanism.UNSET);
                }
            }
        };
        this.view.operationRadioButton.addSelectionListener((SelectionListener)listener);
        this.view.eventRadioButton.addSelectionListener((SelectionListener)listener);
        this.view.sharedRadioButton.addSelectionListener((SelectionListener)listener);
        this.view.flowRadioButton.addSelectionListener((SelectionListener)listener);
        this.view.unsetRadioButton.addSelectionListener((SelectionListener)listener);
        this.view.exchangeItemNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectInvokedOperationController.this.model.setCreatedElementName(SelectInvokedOperationController.this.view.exchangeItemNameText.getText());
                SelectInvokedOperationController.this.updateOkButton();
            }
        });
        this.view.interfaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectInvokedOperationController.this.model.setSelectedInterfaceName(SelectInvokedOperationController.this.view.interfaceText.getText());
                if (!SelectInvokedOperationController.this.model.isValidInterfaceName()) {
                    SelectInvokedOperationController.this.view.setErrorMessage("A technical interface already exists with the given name. Choose another name.");
                } else {
                    if (SelectInvokedOperationController.this.view.getErrorMessage() != null) {
                        SelectInvokedOperationController.this.view.setErrorMessage(null);
                    }
                    if (SelectInvokedOperationController.this.model.doesInterfaceExist()) {
                        SelectInvokedOperationController.this.view.setMessage("The selected interface exists.");
                    } else {
                        SelectInvokedOperationController.this.view.setMessage(null);
                    }
                }
                SelectInvokedOperationController.this.updateOkButton();
            }
        });
        this.view.selectInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectElementsDialog selectInterfaceDialog = new SelectElementsDialog(SelectInvokedOperationController.this.view.getTheParentShell(), TransactionHelper.getEditingDomain(SelectInvokedOperationController.this.model.getInterfaces(false, false)), CapellaAdapterFactoryProvider.getInstance().getAdapterFactory(), Messages.SelectOperationDialog_SelectInterfaceDialog_Title, Messages.SelectOperationDialog_SelectInterfaceDialog_Message, SelectInvokedOperationController.this.model.getInterfaces(true, false));
                if (selectInterfaceDialog.open() == 0) {
                    AbstractNamedElement selectedInterface = (AbstractNamedElement)selectInterfaceDialog.getResult().get(0);
                    SelectInvokedOperationController.this.view.interfaceText.setData((Object)selectedInterface);
                    SelectInvokedOperationController.this.model.setSelectedInterface((Interface)selectedInterface);
                    SelectInvokedOperationController.this.view.interfaceText.setText(selectedInterface.getName());
                    SelectInvokedOperationController.this.model.setSelectedInterfaceName(selectedInterface.getName());
                }
            }
        });
        this.view.optionSelectionA_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setHideTechnicalInterfaceNames(((Button)event.widget).getSelection());
                SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
            }
        });
        this.view.optionSelectionB_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setRestrictToExistingStaticCommunicationCompatibility(((Button)event.widget).getSelection());
                SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
            }
        });
        this.view.optionSelectionC_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setAllowSelectionOfExistingExchangeItems(((Button)event.widget).getSelection());
                SelectInvokedOperationController.this.view.refreshPossibleElementsTree();
            }
        });
        this.view.optionCreationA_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setPortsMustBeCreated(((Button)event.widget).getSelection());
            }
        });
        this.view.optionCreationB_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectInvokedOperationController.this.model.setCommunicationLinksMustBeCreated(((Button)event.widget).getSelection());
            }
        });
        this.updateWindow();
    }

    protected void updateWindow() {
        if (this.view != null) {
            this.updateCreationArea();
            this.upddateInterfaceArea();
            this.view.getTreeViewer().setEnabled(!this.model.doesElementMustBeCreated());
            this.updateSelectionOptionButtons();
            this.updateCreationOptionButtons();
            this.updateOkButton();
        }
    }

    private void updateCreationArea() {
        this.view.eiTypeGroup.setEnabled(this.model.doesElementMustBeCreated() || this.model.getSelectedElement() instanceof ExchangeItem);
        this.view.exchangeItemNameText.setEnabled(this.model.doesElementMustBeCreated());
        this.updateRadioButtons();
    }

    protected void updateRadioButtons() {
        boolean elementIsCreated = this.model.doesElementMustBeCreated();
        List<ExchangeMechanism> compatibleMechanisms = this.model.getCompatibleExchangeMechanism();
        this.view.unsetRadioButton.setEnabled(elementIsCreated && compatibleMechanisms.contains(ExchangeMechanism.UNSET));
        this.view.eventRadioButton.setEnabled(elementIsCreated && compatibleMechanisms.contains(ExchangeMechanism.EVENT));
        this.view.flowRadioButton.setEnabled(elementIsCreated && compatibleMechanisms.contains(ExchangeMechanism.FLOW));
        this.view.sharedRadioButton.setEnabled(elementIsCreated && compatibleMechanisms.contains(ExchangeMechanism.SHARED_DATA));
        this.view.operationRadioButton.setEnabled(elementIsCreated && compatibleMechanisms.contains(ExchangeMechanism.OPERATION));
        ExchangeMechanism mechanism = this.model.getSelectedExchangeMechanism();
        this.view.unsetRadioButton.setSelection(mechanism == ExchangeMechanism.UNSET);
        this.view.eventRadioButton.setSelection(mechanism == ExchangeMechanism.EVENT);
        this.view.flowRadioButton.setSelection(mechanism == ExchangeMechanism.FLOW);
        this.view.sharedRadioButton.setSelection(mechanism == ExchangeMechanism.SHARED_DATA);
        this.view.operationRadioButton.setSelection(mechanism == ExchangeMechanism.OPERATION);
    }

    private void upddateInterfaceArea() {
        this.view.interfaceText.setEnabled(this.model.doesInterfaceNameCanBeEdited());
        this.view.selectInterfaceButton.setEnabled(this.model.doesInterfaceCanBeChosen());
        String interfaceNameInModel = this.model.getSelectedInterfaceName();
        if (!this.view.interfaceText.getText().equals(interfaceNameInModel)) {
            this.view.interfaceText.setText(interfaceNameInModel);
        }
    }

    private void updateSelectionOptionButtons() {
        boolean createExchangeItemIsChecked = this.model.doesElementMustBeCreated();
        this.view.optionSelectionA_button.setEnabled(!createExchangeItemIsChecked);
        this.view.optionSelectionB_button.setEnabled(!createExchangeItemIsChecked);
        this.view.optionSelectionC_button.setEnabled(!createExchangeItemIsChecked);
    }

    private void updateCreationOptionButtons() {
        this.view.optionCreationA_button.setEnabled(this.model.doesPortsCreationCanBeToggled());
        this.view.optionCreationA_button.setSelection(this.model.doesPortsMustBeCreated());
        this.view.optionCreationB_button.setEnabled(this.model.doesCommunicationLinksCreationCanBeToggled());
        this.view.optionCreationB_button.setSelection(this.model.doesCommunicationLinksMustBeCreated());
    }

    protected void updateOkButton() {
        Button okButton = this.view.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(this.model.isValid());
        }
    }
}

