/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;

public class LocateFilteredElementsInCommonNavigatorAction {
    private String commonNavigatorID;

    public LocateFilteredElementsInCommonNavigatorAction(String commonNavigatorID) {
        Assert.isLegal((commonNavigatorID != null && !commonNavigatorID.isEmpty() ? 1 : 0) != 0);
        this.commonNavigatorID = commonNavigatorID;
    }

    public void run(IStructuredSelection selection) {
        ICommonFilterDescriptor[] visibleFilterDescriptors;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = activePage.findView(this.commonNavigatorID);
        Assert.isLegal((boolean)(viewPart instanceof CommonNavigator));
        CommonNavigator commonNavigator = (CommonNavigator)viewPart;
        INavigatorContentService capellaNavigatorContentService = commonNavigator.getNavigatorContentService();
        NavigatorFilterService capellaNavigatorFilterService = (NavigatorFilterService)capellaNavigatorContentService.getFilterService();
        LinkedHashSet<ICommonFilterDescriptor> effectiveFilterDescriptors = new LinkedHashSet<ICommonFilterDescriptor>();
        LinkedHashSet<String> effectiveFilterIds = new LinkedHashSet<String>();
        LinkedHashSet<String> activeFilterIds = new LinkedHashSet<String>();
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleFilterDescriptors = capellaNavigatorFilterService.getVisibleFilterDescriptors();
        int n = visibleFilterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterDescriptor = iCommonFilterDescriptorArray[n2];
            ViewerFilter viewerFilter = capellaNavigatorFilterService.getViewerFilter(filterDescriptor);
            Object[] objectArray = selection.toArray();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object element = objectArray[n4];
                if (capellaNavigatorFilterService.isActive(filterDescriptor.getId())) {
                    activeFilterIds.add(filterDescriptor.getId());
                    if (!this.select(commonNavigator, viewerFilter, element)) {
                        effectiveFilterDescriptors.add(filterDescriptor);
                        effectiveFilterIds.add(filterDescriptor.getId());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!effectiveFilterDescriptors.isEmpty()) {
            StringBuilder dialogMessageBuilder = new StringBuilder();
            dialogMessageBuilder.append(Messages.LocateInCommonNavigator_SelectedElementNotVisible_0);
            for (ICommonFilterDescriptor filterDescriptor : effectiveFilterDescriptors) {
                dialogMessageBuilder.append(" - " + filterDescriptor.getName() + ": " + filterDescriptor.getDescription() + "\n");
            }
            dialogMessageBuilder.append(Messages.LocateInCommonNavigator_SelectedElementNotVisible_1);
            boolean openFilterSelectionDialog = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)NLS.bind((String)Messages.LocateInCommonNavigator_SelectedElementNotVisible_Title, (Object)commonNavigator.getPartName()), (String)dialogMessageBuilder.toString());
            if (openFilterSelectionDialog) {
                activeFilterIds.removeAll(effectiveFilterIds);
                capellaNavigatorFilterService.activateFilterIdsAndUpdateViewer(activeFilterIds.toArray(new String[0]));
            }
        }
    }

    protected boolean select(CommonNavigator commonNavigator, ViewerFilter viewerFilter, Object element) {
        boolean select = true;
        Object parent = element;
        while (select && parent != null && !(parent instanceof IFile)) {
            select = viewerFilter.select((Viewer)commonNavigator.getCommonViewer(), null, parent);
            ITreeContentProvider contentProvider = (ITreeContentProvider)commonNavigator.getCommonViewer().getContentProvider();
            parent = contentProvider.getParent(parent);
        }
        return select;
    }
}

