/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.resources;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ui.services.AbstractUIActivator;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;

public class CapellaUIResourcesPlugin
extends AbstractUIActivator {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.ui.resources";
    private static CapellaUIResourcesPlugin __plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }

    public static CapellaUIResourcesPlugin getDefault() {
        return __plugin;
    }

    public ImageDescriptor getPNGImage(EClass eclass_p) {
        String key = "full/png/" + eclass_p.getName() + ".png";
        return this.getMetaClassImageDescriptor(key);
    }

    public ImageDescriptor getPNGImage(EObject eobject_p) {
        String key = "full/png/" + this.getCustomizedImageName(eobject_p) + ".png";
        return this.getMetaClassImageDescriptor(key);
    }

    public ImageDescriptor getSVGImage(EClass eclass_p) {
        String key = "full/svg/" + eclass_p.getName() + ".svg";
        return this.getMetaClassImageDescriptor(key);
    }

    private ImageDescriptor getMetaClassImageDescriptor(String metaClassImageDescriptorKey_p) {
        ImageDescriptor result = null;
        if (this.getImageURL(metaClassImageDescriptorKey_p) != null) {
            result = super.getImageDescriptor(metaClassImageDescriptorKey_p);
        }
        return result;
    }

    public String getCustomizedImageName(EObject eobject_p) {
        String eClassName = eobject_p.eClass().getName();
        if (eobject_p instanceof PhysicalComponent) {
            if (PhysicalComponentNature.NODE.equals((Object)((PhysicalComponent)eobject_p).getNature())) {
                eClassName = "PhysicalComponentNode";
            }
        } else if (eobject_p instanceof Part) {
            AbstractType type = ((Part)eobject_p).getAbstractType();
            if (type instanceof AbstractActor) {
                eClassName = "Part_AbstractActor";
            } else if (type instanceof PhysicalComponent) {
                if (PhysicalComponentNature.BEHAVIOR.equals((Object)((PhysicalComponent)type).getNature())) {
                    eClassName = "Part_PCBehaviour";
                } else if (PhysicalComponentNature.NODE.equals((Object)((PhysicalComponent)type).getNature())) {
                    eClassName = "Part_PCNode";
                }
            }
        } else if (eobject_p instanceof CommunicationLink) {
            CommunicationLinkKind kind = ((CommunicationLink)eobject_p).getKind();
            if (CommunicationLinkKind.PRODUCE.equals((Object)kind)) {
                eClassName = "CommunicationLinkProduce";
            } else if (CommunicationLinkKind.CONSUME.equals((Object)kind)) {
                eClassName = "CommunicationLinkConsume";
            } else if (CommunicationLinkKind.SEND.equals((Object)kind)) {
                eClassName = "CommunicationLinkSend";
            } else if (CommunicationLinkKind.RECEIVE.equals((Object)kind)) {
                eClassName = "CommunicationLinkReceive";
            } else if (CommunicationLinkKind.CALL.equals((Object)kind)) {
                eClassName = "CommunicationLinkCall";
            } else if (CommunicationLinkKind.EXECUTE.equals((Object)kind)) {
                eClassName = "CommunicationLinkExecute";
            } else if (CommunicationLinkKind.WRITE.equals((Object)kind)) {
                eClassName = "CommunicationLinkWrite";
            } else if (CommunicationLinkKind.ACCESS.equals((Object)kind)) {
                eClassName = "CommunicationLinkAccess";
            } else if (CommunicationLinkKind.ACQUIRE.equals((Object)kind)) {
                eClassName = "CommunicationLinkAcquire";
            } else if (CommunicationLinkKind.TRANSMIT.equals((Object)kind)) {
                eClassName = "CommunicationLinkTransmit";
            }
        } else if (eobject_p instanceof ExchangeItem) {
            if (((ExchangeItem)eobject_p).getExchangeMechanism() == ExchangeMechanism.EVENT) {
                eClassName = "ExchangeItemEvent";
            } else if (ExchangeMechanism.FLOW.equals((Object)((ExchangeItem)eobject_p).getExchangeMechanism())) {
                eClassName = "ExchangeItemFlow";
            } else if (ExchangeMechanism.OPERATION.equals((Object)((ExchangeItem)eobject_p).getExchangeMechanism())) {
                eClassName = "ExchangeItemOperation";
            } else if (ExchangeMechanism.SHARED_DATA.equals((Object)((ExchangeItem)eobject_p).getExchangeMechanism())) {
                eClassName = "ExchangeItemData";
            }
        } else if (eobject_p instanceof FunctionalExchange) {
            if (((FunctionalExchange)eobject_p).getSource() instanceof OperationalActivity && ((FunctionalExchange)eobject_p).getTarget() instanceof OperationalActivity) {
                eClassName = "FunctionalExchange_OA";
            }
        } else if (eobject_p instanceof ComponentPort) {
            ComponentPortKind kind = ((ComponentPort)eobject_p).getKind();
            if (ComponentPortKind.STANDARD.equals((Object)kind)) {
                eClassName = "StandardPort";
            } else if (ComponentPortKind.FLOW.equals((Object)kind)) {
                eClassName = "FlowPort";
                if (OrientationPortKind.IN.equals((Object)((ComponentPort)eobject_p).getOrientation())) {
                    eClassName = "InFlowPort";
                } else if (OrientationPortKind.OUT.equals((Object)((ComponentPort)eobject_p).getOrientation())) {
                    eClassName = "OutFlowPort";
                }
            }
        } else if (eobject_p instanceof AbstractFunction) {
            FunctionKind kind = ((AbstractFunction)eobject_p).getKind();
            if (FunctionKind.DUPLICATE.equals((Object)kind)) {
                eClassName = "FunctionKind_Duplicate";
            } else if (FunctionKind.GATHER.equals((Object)kind)) {
                eClassName = "FunctionKind_Gather";
            } else if (FunctionKind.ROUTE.equals((Object)kind)) {
                eClassName = "FunctionKind_Route";
            } else if (FunctionKind.SELECT.equals((Object)kind)) {
                eClassName = "FunctionKind_Select";
            } else if (FunctionKind.SPLIT.equals((Object)kind)) {
                eClassName = "FunctionKind_Split";
            }
        }
        return eClassName;
    }
}

