/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.es2es.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.projection.common.CommonRule;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.CommonScenarioHelper;
import org.polarsys.capella.core.projection.scenario.es2es.rules.ScenarioFinalizer;
import org.polarsys.capella.core.projection.scenario.es2es.rules.ScenarioHelper;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;

public class Rule_Scenario
extends CommonRule {
    public Rule_Scenario() {
        super(InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO_REALIZATION);
    }

    protected void runSubTransitionBeforeTransform(EObject element_p, ITransfo transfo_p) {
        Scenario scenario = (Scenario)element_p;
        for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
            AbstractInstance instance = role.getRepresentedInstance();
            if (instance == null || !(instance.getAbstractType() instanceof Component)) continue;
            Component type = (Component)instance.getAbstractType();
            ArrayList<AbstractInstance> elements = new ArrayList<AbstractInstance>();
            elements.add(instance);
            NullProgressMonitor monitor = new NullProgressMonitor();
            ICommand command = null;
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)type)) {
                command = type instanceof AbstractActor ? TransitionCommandHelper.getInstance().getActorTransitionCommand(elements, (IProgressMonitor)monitor) : TransitionCommandHelper.getInstance().getActorTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)type)) {
                command = type instanceof AbstractActor ? TransitionCommandHelper.getInstance().getActorTransitionCommand(elements, (IProgressMonitor)monitor) : TransitionCommandHelper.getInstance().getLC2PCTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)type) && !Query.isElementTransformed((EObject)type, (ITransfo)transfo_p)) {
                command = TransitionCommandHelper.getInstance().getOE2ActorTransitionCommand(elements, (IProgressMonitor)monitor);
            }
            if (command == null) continue;
            command.run();
        }
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            AbstractEventOperation operation = CommonScenarioHelper.getOperation((EObject)message, transfo_p);
            if (operation == null || ScenarioFinalizer.isTransformed(operation)) continue;
            if (operation instanceof FunctionalExchange) {
                ArrayList<AbstractEventOperation> elements = new ArrayList<AbstractEventOperation>();
                elements.add(operation);
                NullProgressMonitor monitor = new NullProgressMonitor();
                ICommand command = null;
                if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)operation)) {
                    command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
                } else if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)operation)) {
                    command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
                } else if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)operation)) {
                    command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
                }
                if (command != null) {
                    command.run();
                }
            }
            ScenarioFinalizer.registerTransformed(operation);
        }
    }

    protected Object transformElement(EObject element_p, ITransfo transfo_p) {
        Object result = super.transformElement(element_p, transfo_p);
        transfo_p.put((Object)"transfoTarget", result);
        ScenarioHelper.getRelatedInstances((Scenario)element_p, transfo_p);
        return result;
    }

    public void update_(EObject element_p, ITransfo transfo_p) {
        super.update_(element_p, transfo_p);
        Scenario source = (Scenario)element_p;
        ScenarioKind targetKind = ScenarioKind.DATA_FLOW;
        if (TransitionHelper.getService().isFunctionalScenario(source)) {
            targetKind = ScenarioKind.FUNCTIONAL;
        }
        for (Scenario target : Query.retrieveUnattachedTransformedElements((EObject)source, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            target.setKind(targetKind);
        }
    }

    public void firstAttach(EObject element_p, ITransfo transfo_p) {
        TigerRelationshipHelper.attachUnattachedIntoTransformedContainer((EObject)element_p, (EClass)this.getTargetType(), (EReference)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_SCENARIOS, (ITransfo)transfo_p);
        TigerRelationshipHelper.attachTransformedRelatedElements((EObject)element_p, (EReference)InteractionPackage.Literals.SCENARIO__PRE_CONDITION, (ITransfo)transfo_p);
        TigerRelationshipHelper.attachTransformedRelatedElements((EObject)element_p, (EReference)InteractionPackage.Literals.SCENARIO__POST_CONDITION, (ITransfo)transfo_p);
    }

    protected void doGoDeep(EObject element_p, List<EObject> result_p) {
        super.doGoDeep(element_p, result_p);
        Scenario s = (Scenario)element_p;
        result_p.add((EObject)s.getPreCondition());
        result_p.add((EObject)s.getPostCondition());
        result_p.addAll((Collection<EObject>)s.getOwnedMessages());
        result_p.addAll((Collection<EObject>)s.getOwnedEvents());
        result_p.addAll((Collection<EObject>)s.getOwnedInteractionFragments());
        result_p.addAll((Collection<EObject>)s.getOwnedTimeLapses());
        result_p.addAll((Collection<EObject>)s.getOwnedInstanceRoles());
    }

    protected void doAddContainer(EObject element_p, List<EObject> result_p) {
        if (!Query.isElementTransformed((EObject)element_p.eContainer(), (ITransfo)this._transfo)) {
            super.doAddContainer(element_p, result_p);
        }
    }
}

