/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.data.modellingcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterEffectKind implements Enumerator
{
    CREATE(2, "create", "create"),
    READ(0, "read", "read"),
    UPDATE(1, "update", "update"),
    DELETE(3, "delete", "delete");

    public static final int CREATE_VALUE = 2;
    public static final int READ_VALUE = 0;
    public static final int UPDATE_VALUE = 1;
    public static final int DELETE_VALUE = 3;
    private static final ParameterEffectKind[] VALUES_ARRAY;
    public static final List<ParameterEffectKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterEffectKind[]{CREATE, READ, UPDATE, DELETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterEffectKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterEffectKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterEffectKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterEffectKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterEffectKind get(int value) {
        switch (value) {
            case 2: {
                return CREATE;
            }
            case 0: {
                return READ;
            }
            case 1: {
                return UPDATE;
            }
            case 3: {
                return DELETE;
            }
        }
        return null;
    }

    private ParameterEffectKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

