/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class CapellaShadedNonValidElementLabelProvider
extends CapellaElementLabelProvider
implements IColorProvider,
IFontProvider {
    protected Font _font;
    protected Color _invalidColor;
    protected Color _validColor;
    protected boolean _isValidElementsSet = false;
    protected List<EObject> _validElements = new ArrayList<EObject>(0);

    public void dispose() {
        if (this._font != null) {
            this._font.dispose();
        }
        super.dispose();
    }

    public String getText(Object element_p) {
        Map.Entry entry;
        EObject key;
        if (element_p instanceof AbstractNamedElement) {
            String eleMentName = ((AbstractNamedElement)element_p).getName();
            if (element_p instanceof Part) {
                String typeName;
                Part partEle = (Part)element_p;
                AbstractType abstractType = partEle.getAbstractType();
                eleMentName = abstractType != null ? ((typeName = abstractType.getName()) != null ? String.valueOf(eleMentName) + ": " + typeName : String.valueOf(eleMentName) + ": <undefined>") : String.valueOf(eleMentName) + ": <undefined>";
            } else if (element_p instanceof Operation) {
                Operation operation = (Operation)element_p;
                EList parameters = operation.getOwnedParameters();
                if (!parameters.isEmpty()) {
                    eleMentName = String.valueOf(eleMentName) + "(";
                    Iterator iter = parameters.iterator();
                    while (iter.hasNext()) {
                        Parameter parameter = (Parameter)iter.next();
                        eleMentName = String.valueOf(eleMentName) + " " + parameter.getName();
                        if (!iter.hasNext()) continue;
                        eleMentName = String.valueOf(eleMentName) + ",";
                    }
                    eleMentName = String.valueOf(eleMentName) + " )";
                } else {
                    eleMentName = String.valueOf(eleMentName) + " ()";
                }
            }
            return eleMentName;
        }
        if (element_p instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element_p).getValue()) != null && key instanceof AbstractNamedElement) {
            String name = ((AbstractNamedElement)key).getName();
            return name;
        }
        return super.getText(element_p);
    }

    public Font getFont(Object element_p) {
        Map.Entry entry;
        EObject key;
        if (element_p instanceof AbstractNamedElement) {
            if (this._isValidElementsSet && !this._validElements.contains(element_p)) {
                if (this._font == null) {
                    this._font = this.createInvalidElementFont();
                }
                return this._font;
            }
        } else if (element_p instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element_p).getValue()) != null && key instanceof AbstractNamedElement && this._isValidElementsSet && !this._validElements.contains(key)) {
            if (this._font == null) {
                this._font = this.createInvalidElementFont();
            }
            return this._font;
        }
        return null;
    }

    protected Font createInvalidElementFont() {
        return new Font((Device)Display.getDefault(), "Arial", 9, 2);
    }

    public Color getBackground(Object element_p) {
        return null;
    }

    public Color getForeground(Object element_p) {
        Map.Entry entry;
        EObject key;
        if (element_p instanceof AbstractNamedElement) {
            return this.getValidForeGround(element_p);
        }
        if (element_p instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element_p).getValue()) != null && key instanceof AbstractNamedElement) {
            return this.getValidForeGround(key);
        }
        return this._validColor;
    }

    protected Color getValidForeGround(Object element_p) {
        if (this._isValidElementsSet && !this._validElements.contains(element_p)) {
            if (this._invalidColor == null) {
                this._invalidColor = Display.getDefault().getSystemColor(16);
            }
            return this._invalidColor;
        }
        if (this._validColor == null) {
            this._validColor = Display.getDefault().getSystemColor(2);
        }
        return this._validColor;
    }

    public List<EObject> get_notValidList() {
        return this._validElements;
    }

    public void set_ValidList(List<EObject> validList) {
        this._isValidElementsSet = true;
        this._validElements = validList;
    }

    public Image getImage(Object element_p) {
        Map.Entry entry;
        EObject key;
        if (element_p instanceof AbstractNamedElement) {
            return super.getImage(element_p);
        }
        if (element_p instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element_p).getValue()) != null && key instanceof AbstractNamedElement) {
            return super.getImage((Object)key);
        }
        return super.getImage(element_p);
    }
}

