/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;

public final class GmfUtil {
    private GmfUtil() {
    }

    public static View getCommonViewAncestor(Collection<? extends View> views) {
        if (views == null || views.isEmpty()) {
            return null;
        }
        List<Node> commonHierarchy = null;
        for (View view : views) {
            if (view instanceof Diagram) {
                return view;
            }
            if (!(view instanceof Node)) continue;
            List<Node> currentHierarchy = GmfUtil.getSimilarContainers((Node)view, Node.class);
            if (commonHierarchy == null) {
                commonHierarchy = currentHierarchy;
                continue;
            }
            commonHierarchy.retainAll(currentHierarchy);
        }
        if (commonHierarchy != null) {
            commonHierarchy.removeAll(views);
            if (commonHierarchy.isEmpty()) {
                return views.iterator().next().getDiagram();
            }
            return (View)commonHierarchy.get(commonHierarchy.size() - 1);
        }
        return null;
    }

    private static <T extends EObject> List<T> getSimilarContainers(T element_p, Class<T> higherType_p) {
        if (element_p == null) {
            return new ArrayList();
        }
        EObject container = element_p.eContainer();
        if (higherType_p.isInstance(container)) {
            EObject castedContainer = container;
            List<EObject> result = GmfUtil.getSimilarContainers(castedContainer, higherType_p);
            result.add(element_p);
            return result;
        }
        ArrayList<T> result = new ArrayList<T>(1);
        result.add(element_p);
        return result;
    }

    public static Point getAbsoluteTopLeftCorner(Collection<? extends Node> nodes_p) {
        List<? extends Node> roots = MiscUtil.getRoots(nodes_p);
        Point result = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        boolean computed = false;
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            Point current = GmfUtil.getAbsoluteLocation((Node)it.next());
            if (current == null) continue;
            result.x = Math.min(result.x, current.x);
            result.y = Math.min(result.y, current.y);
            if (computed) continue;
            computed = true;
        }
        if (computed) {
            return result;
        }
        return null;
    }

    public static Point getRelativeLocation(Node node) {
        Point result = null;
        LayoutConstraint layout = node.getLayoutConstraint();
        if (layout instanceof Location) {
            Location location = (Location)layout;
            result = new Point(location.getX(), location.getY());
        }
        return result;
    }

    public static Point getAbsoluteLocation(Node node) {
        Point result = null;
        EObject container = node.eContainer();
        Point relative = GmfUtil.getRelativeLocation(node);
        if (container instanceof Diagram) {
            result = relative;
        } else if (container instanceof Node) {
            Point absolute = GmfUtil.getAbsoluteLocation((Node)container);
            if (absolute != null && relative != null) {
                result = new Point(absolute.x + relative.x, absolute.y + relative.y);
            } else if (relative == null) {
                result = absolute;
            }
        }
        return result;
    }

    public static Point getEditPartRelativeLocation(Point location, GraphicalEditPart editPart) {
        Point editPartLocation = GmfUtil.getAbsoluteLocation(editPart);
        return new Point(location.x - editPartLocation.x, location.y - editPartLocation.y);
    }

    public static Point getAbsoluteLocation(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Control canvas = editPart.getViewer().getControl();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        Point swtPoint = new Point(bounds.x, bounds.y);
        return canvas.getDisplay().map(canvas, null, swtPoint);
    }
}

