/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractExportDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.IExportConstants;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractRegExpViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.RegExpTreeViewer;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.core.MetricTree;
import org.polarsys.capella.core.ui.metric.dialog.MetricContentProvider;
import org.polarsys.capella.core.ui.metric.dialog.MetricLabelProvider;

public class MetricDialog
extends AbstractExportDialog {
    protected String _resourceName;

    public MetricDialog(Shell parentShell, String title, String message, String shellTitle) {
        super(parentShell, title, message, shellTitle);
    }

    protected List<String[]> getExportableData() {
        List result = super.getExportableData(this._resourceName);
        ArrayList<MetricTree<EObject>> ses = new ArrayList<MetricTree<EObject>>();
        MetricTree data = (MetricTree)this.getData();
        EClass eRoot = ((EObject)data.getId()).eClass();
        if (CapellacorePackage.Literals.MODELLING_ARCHITECTURE.isSuperTypeOf(eRoot)) {
            result.addAll(this.serializeLayerNodes(Collections.singletonList(data)));
        } else {
            if (eRoot == CapellamodellerPackage.Literals.PROJECT) {
                ses.addAll(data.getChildren());
            } else if (eRoot == CapellamodellerPackage.Literals.SYSTEM_ENGINEERING) {
                ses.add(data);
            }
            result.addAll(this.serializeSysEngNodes(ses));
        }
        return result;
    }

    private List<String[]> serializeSysEngNodes(List<MetricTree<EObject>> nodes_p) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (MetricTree<EObject> node : nodes_p) {
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.add(new String[]{String.valueOf(node.getId().eClass().getName()) + ':' + MetricLabelProvider.getLabelText(node.getId(), null)});
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.addAll(this.serializeLayerNodes(node.getChildren()));
        }
        return result;
    }

    private List<String[]> serializeLayerNodes(List<MetricTree<EObject>> nodes_p) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (MetricTree<EObject> node : nodes_p) {
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.add(new String[]{String.valueOf(MetricMessages.layer) + ':' + MetricLabelProvider.getLabelText(node.getId(), null)});
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            for (MetricTree<EObject> node2 : node.getChildren()) {
                result.add(new String[]{MetricLabelProvider.getLabelText(node2.getId(), null), node2.getData().toString()});
            }
        }
        return result;
    }

    protected AbstractRegExpViewer createViewer(Composite parent_p) {
        RegExpTreeViewer treeViewer = new RegExpTreeViewer(parent_p);
        TreeViewer viewer = treeViewer.getClientViewer();
        TreeViewerColumn columnViewer = new TreeViewerColumn(viewer, 16384);
        TreeColumn column = columnViewer.getColumn();
        column.setText(MetricMessages.treeObjectColumnLabel);
        column.setWidth(300);
        ViewerComparator vc = new ViewerComparator(){

            public int compare(Viewer viewer_p, Object e1_p, Object e2_p) {
                int result = 0;
                MetricTree node1 = (MetricTree)e1_p;
                MetricTree node2 = (MetricTree)e2_p;
                if (!node1.hasChildren()) {
                    String lbl1 = MetricLabelProvider.getLabelText((EObject)node1.getId(), null);
                    String lbl2 = MetricLabelProvider.getLabelText((EObject)node2.getId(), null);
                    result = lbl1.compareTo(lbl2);
                }
                return result;
            }
        };
        viewer.setComparator(vc);
        columnViewer = new TreeViewerColumn(viewer, 16388);
        column = columnViewer.getColumn();
        column.setText(MetricMessages.treeResultColumnLabel);
        column.setWidth(70);
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new MetricContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MetricLabelProvider());
        return treeViewer;
    }

    public void setResourceName(String name_p) {
        this._resourceName = name_p;
    }
}

