/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.sirius.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;

public class DiagramOpenAction {
    private ISelection _selection;
    private SemanticBrowserView _semanticBrowserView;

    public void init(IWorkbenchPart part_p) {
        this._semanticBrowserView = (SemanticBrowserView)part_p;
    }

    protected void postEditorOpen(Object element_p, IEditorPart openEditor_p) {
    }

    public void run(IAction action_p) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this._selection;
        DRepresentationDescriptor representation = (DRepresentationDescriptor)structuredSelection.getFirstElement();
        Object currentElement = this._semanticBrowserView.getCurrentViewer().getInput();
        boolean listeningToPageSelectionEvents = SemanticBrowserView.isListeningToPageSelectionEvents();
        EObject target = representation.getTarget();
        if (target != null) {
            try {
                if (listeningToPageSelectionEvents) {
                    this._semanticBrowserView.deactivateListeningToPageSelectionEvents();
                }
                Session session = SessionManager.INSTANCE.getSession(target);
                IEditorPart openEditor = DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
                this.postEditorOpen(currentElement, openEditor);
            }
            finally {
                if (listeningToPageSelectionEvents) {
                    this._semanticBrowserView.activateListeningToPageSelectionEvents();
                }
            }
        }
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        this._selection = selection_p.isEmpty() ? null : selection_p;
    }
}

