/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.FileStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

class DiffStructureVisitor
extends FileStructureVisitor {
    public DiffStructureVisitor(Session session, Command.LocalOption[] localOptions) {
        super(session, localOptions, true, true);
    }

    @Override
    protected void sendFile(ICVSFile mFile) throws CVSException {
        byte[] info = mFile.getSyncBytes();
        if (info == null) {
            return;
        }
        this.sendFolder(mFile.getParent());
        Policy.checkCanceled(this.monitor);
        this.session.sendEntry(info, null);
        if (!mFile.exists()) {
            return;
        }
        if (mFile.isModified(null)) {
            this.session.sendModified(mFile, ResourceSyncInfo.isBinary(info), this.monitor);
        } else {
            this.session.sendUnchanged(mFile);
        }
    }
}

