/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.la.SystemRealization;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreateLogicalArchiCmd
extends AbstractReadWriteCommand {
    private String _architectureName;
    private LogicalArchitecture _logicalArchitecture;
    private SystemFunction _systemFunction;
    private System _system;
    private SystemAnalysis _ctxArchitecture;
    private LogicalFunction _logicalFunction;
    private LogicalComponent _rootComponent;
    private SystemEngineering _systemEng;

    public CreateLogicalArchiCmd(SystemEngineering systemEng_p, String architectureName_p, SystemAnalysis ctxArchitecture_p, SystemFunction systemFunction_p, System system_p) {
        this._architectureName = architectureName_p;
        this._ctxArchitecture = ctxArchitecture_p;
        this._systemFunction = systemFunction_p;
        this._system = system_p;
        this._systemEng = systemEng_p;
    }

    public void run() {
        this._logicalArchitecture = LaFactory.eINSTANCE.createLogicalArchitecture(this._architectureName);
        LogicalFunctionPkg logicalFunctionPkg = LaFactory.eINSTANCE.createLogicalFunctionPkg(NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name);
        this._logicalArchitecture.setOwnedFunctionPkg((FunctionPkg)logicalFunctionPkg);
        this._logicalFunction = LaFactory.eINSTANCE.createLogicalFunction(NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name);
        logicalFunctionPkg.getOwnedLogicalFunctions().add((Object)this._logicalFunction);
        FunctionRealization functionRealisation = FaFactory.eINSTANCE.createFunctionRealization();
        this._logicalFunction.getOwnedFunctionRealizations().add((Object)functionRealisation);
        functionRealisation.setSourceElement((TraceableElement)this._logicalFunction);
        if (this._systemFunction != null) {
            functionRealisation.setTargetElement((TraceableElement)this._systemFunction);
        }
        InterfacePkg interfacesPkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        this._logicalArchitecture.setOwnedInterfacePkg(interfacesPkg);
        DataPkg dataPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
        this._logicalArchitecture.setOwnedDataPkg(dataPkg);
        this._rootComponent = LaFactory.eINSTANCE.createLogicalComponent(NamingConstants.CreateLogicalArchCmd_logicalComponent_name);
        this._logicalArchitecture.setOwnedLogicalComponent(this._rootComponent);
        LogicalContext logicalContext = LaFactory.eINSTANCE.createLogicalContext(NamingConstants.CreateLogicalArchCmd_logicalContext_name);
        this._logicalArchitecture.setOwnedLogicalContext(logicalContext);
        Part logicalRootPart = CsFactory.eINSTANCE.createPart(this._rootComponent.getName());
        logicalContext.getOwnedFeatures().add((Object)logicalRootPart);
        logicalRootPart.setAbstractType((AbstractType)this._rootComponent);
        SystemRealization systemRealisation = LaFactory.eINSTANCE.createSystemRealization();
        this._rootComponent.getOwnedSystemRealizations().add((Object)systemRealisation);
        systemRealisation.setSourceElement((TraceableElement)this._rootComponent);
        if (this._system != null) {
            systemRealisation.setTargetElement((TraceableElement)this._system);
        }
        LogicalActorPkg logicalActorsPkg = LaFactory.eINSTANCE.createLogicalActorPkg(NamingConstants.CreateLogicalArchCmd_actors_pkg_name);
        this._logicalArchitecture.setOwnedLogicalActorPkg(logicalActorsPkg);
        SystemAnalysisRealization ctxArchitectureRealisation = LaFactory.eINSTANCE.createSystemAnalysisRealization();
        this._logicalArchitecture.getOwnedSystemAnalysisRealizations().add((Object)ctxArchitectureRealisation);
        ctxArchitectureRealisation.setSourceElement((TraceableElement)this._logicalArchitecture);
        if (this._ctxArchitecture != null) {
            ctxArchitectureRealisation.setTargetElement((TraceableElement)this._ctxArchitecture);
        }
        CapabilityRealizationPkg capaRealisationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
        this._logicalArchitecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capaRealisationPkg);
        this._systemEng.getOwnedArchitectures().add((Object)this._logicalArchitecture);
    }

    public LogicalArchitecture getLogicalArchitecture() {
        return this._logicalArchitecture;
    }

    public LogicalFunction getLogicalFunction() {
        return this._logicalFunction;
    }

    public LogicalComponent getLogicalComponent() {
        return this._rootComponent;
    }

    public String getName() {
        return Messages.getString("capella.logical_archi.create.cmd");
    }
}

